/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Request;
import javax.ws.rs.ext.FilterContext;
import javax.ws.rs.ext.RequestFilter;

public class CsrfProtectionFilter
implements RequestFilter {
    public static final String HEADER_NAME = "X-Requested-By";
    private static final Set<String> METHODS_TO_IGNORE;
    private final String requestedBy;

    public CsrfProtectionFilter() {
        this("");
    }

    public CsrfProtectionFilter(String requestedBy) {
        this.requestedBy = requestedBy;
    }

    public final void preFilter(FilterContext fc) throws IOException {
        Request request = fc.getRequest();
        if (!METHODS_TO_IGNORE.contains(request.getMethod()) && request.getHeaders().getHeader(HEADER_NAME) == null) {
            fc.setRequest(fc.getRequestBuilder().header(HEADER_NAME, (Object)this.requestedBy).build());
        }
    }

    static {
        HashSet<String> mti = new HashSet<String>();
        mti.add("GET");
        mti.add("OPTIONS");
        mti.add("HEAD");
        METHODS_TO_IGNORE = Collections.unmodifiableSet(mti);
    }
}

