/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyInvocation;
import org.glassfish.jersey.client.JerseyWebTarget;

public class JerseyClient
implements Client {
    private final AtomicBoolean closedFlag = new AtomicBoolean(false);
    private final ClientConfig configuration;
    private final LinkedBlockingDeque<LifecycleListener> listeners = new LinkedBlockingDeque();

    protected JerseyClient() {
        this.configuration = new ClientConfig(this);
    }

    protected JerseyClient(Configurable configuration) {
        this.configuration = new ClientConfig(this, configuration);
    }

    public void close() {
        if (this.closedFlag.compareAndSet(false, true)) {
            this.release();
        }
    }

    private void release() {
        LifecycleListener listener;
        while ((listener = this.listeners.pollFirst()) != null) {
            listener.onClose();
        }
    }

    public void addListener(LifecycleListener listener) {
        this.checkNotClosed();
        this.listeners.push(listener);
    }

    public boolean isClosed() {
        return this.closedFlag.get();
    }

    void checkNotClosed() throws IllegalStateException {
        Preconditions.checkState((!this.closedFlag.get() ? 1 : 0) != 0, (Object)"Client instance has been closed.");
    }

    public ClientConfig configuration() {
        this.checkNotClosed();
        return this.configuration;
    }

    public JerseyWebTarget target(String uri) throws IllegalArgumentException, NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)uri, (Object)"URI template of the newly created target must not be 'null'.");
        return new JerseyWebTarget(uri, this);
    }

    public JerseyWebTarget target(URI uri) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)uri, (Object)"URI of the newly created target must not be 'null'.");
        return new JerseyWebTarget(uri, this);
    }

    public JerseyWebTarget target(UriBuilder uriBuilder) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)uriBuilder, (Object)"URI builder of the newly created target must not be 'null'.");
        return new JerseyWebTarget(uriBuilder, this);
    }

    public JerseyWebTarget target(Link link) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)link, (Object)"Link to the newly created target must not be 'null'.");
        return new JerseyWebTarget(link, this);
    }

    public JerseyInvocation.Builder invocation(Link link) throws NullPointerException, IllegalArgumentException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)link, (Object)"Link of the newly created invocation must not be 'null'.");
        JerseyWebTarget t = new JerseyWebTarget(link, this);
        String acceptType = link.getType();
        return acceptType != null ? t.request(acceptType) : t.request();
    }

    static interface LifecycleListener {
        public void onClose();
    }
}

