/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.message.internal.InboundMessageContext;
import org.glassfish.jersey.message.internal.OutboundJaxrsResponse;
import org.glassfish.jersey.message.internal.Statuses;

public class ClientResponse
extends InboundMessageContext
implements ClientResponseContext {
    private Response.StatusType status;
    private final ClientRequest requestContext;

    public ClientResponse(final ClientRequest requestContext, final Response response) {
        this(response.getStatusInfo(), requestContext);
        this.headers(OutboundJaxrsResponse.from((Response)response).getContext().getStringHeaders());
        final Object entity = response.getEntity();
        if (entity != null) {
            InputStream entityStream = new InputStream(){
                private ByteArrayInputStream byteArrayInputStream = null;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int read() throws IOException {
                    if (this.byteArrayInputStream == null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        OutputStream stream = null;
                        try {
                            try {
                                stream = requestContext.getWorkers().writeTo(entity, entity.getClass(), null, null, response.getMediaType(), response.getMetadata(), requestContext.getPropertiesDelegate(), (OutputStream)baos, Collections.emptyList());
                            }
                            finally {
                                if (stream != null) {
                                    stream.close();
                                }
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                    }
                    return this.byteArrayInputStream.read();
                }
            };
            this.setEntityStream(entityStream);
        }
    }

    public ClientResponse(Response.StatusType status, ClientRequest requestContext) {
        this.status = status;
        this.requestContext = requestContext;
        final Iterable<ReaderInterceptor> readerInterceptors = requestContext.getReaderInterceptors();
        this.setWorkers(requestContext.getWorkers());
        this.setReaderInterceptors((Value)new Value<Iterable<ReaderInterceptor>>(){

            public Iterable<ReaderInterceptor> get() {
                return readerInterceptors;
            }
        });
    }

    public int getStatus() {
        return this.status.getStatusCode();
    }

    public void setStatus(int code) {
        this.status = Statuses.from((int)code);
    }

    public void setStatusInfo(Response.StatusType status) {
        if (status == null) {
            throw new NullPointerException("Response status must not be 'null'");
        }
        this.status = status;
    }

    public Response.StatusType getStatusInfo() {
        return this.status;
    }

    public ClientRequest getRequestContext() {
        return this.requestContext;
    }

    public Map<String, NewCookie> getCookies() {
        return super.getResponseCookies();
    }

    public Set<Link> getLinks() {
        return Sets.newHashSet((Iterable)Collections2.transform((Collection)super.getLinks(), (Function)new Function<Link, Link>(){

            public Link apply(Link link) {
                if (link.getUri().isAbsolute()) {
                    return link;
                }
                return Link.fromLink((Link)link).baseUri(ClientResponse.this.requestContext.getUri()).build(new Object[0]);
            }
        }));
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("method", (Object)this.requestContext.getMethod()).add("uri", (Object)this.requestContext.getUri()).add("status", this.status.getStatusCode()).add("reason", (Object)this.status.getReasonPhrase()).toString();
    }
}

