/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.RedirectionException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.CompletionStageRxInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.NioInvoker;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.RxInvokerProvider;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import jersey.repackaged.com.google.common.util.concurrent.SettableFuture;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.ClientRuntime;
import org.glassfish.jersey.client.InboundJaxrsResponse;
import org.glassfish.jersey.client.JerseyCompletionStageRxInvoker;
import org.glassfish.jersey.client.ResponseCallback;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.util.Producer;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.process.internal.RequestScope;

public class JerseyInvocation
implements Invocation {
    private static final Logger LOGGER = Logger.getLogger(JerseyInvocation.class.getName());
    private final ClientRequest requestContext;
    private final boolean copyRequestContext;
    private static final Map<String, EntityPresence> METHODS = JerseyInvocation.initializeMap();

    private JerseyInvocation(Builder builder) {
        this(builder, false);
    }

    private JerseyInvocation(Builder builder, boolean copyRequestContext) {
        this.validateHttpMethodAndEntity(builder.requestContext);
        this.requestContext = new ClientRequest(builder.requestContext);
        this.copyRequestContext = copyRequestContext;
    }

    private static Map<String, EntityPresence> initializeMap() {
        HashMap<String, EntityPresence> map = new HashMap<String, EntityPresence>();
        map.put("DELETE", EntityPresence.MUST_BE_NULL);
        map.put("GET", EntityPresence.MUST_BE_NULL);
        map.put("HEAD", EntityPresence.MUST_BE_NULL);
        map.put("OPTIONS", EntityPresence.MUST_BE_NULL);
        map.put("POST", EntityPresence.OPTIONAL);
        map.put("PUT", EntityPresence.MUST_BE_PRESENT);
        map.put("TRACE", EntityPresence.MUST_BE_NULL);
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateHttpMethodAndEntity(ClientRequest request) {
        String method;
        EntityPresence entityPresence;
        boolean suppressExceptions = PropertiesHelper.isProperty((Object)request.getConfiguration().getProperty("jersey.config.client.suppressHttpComplianceValidation"));
        Object shcvProperty = request.getProperty("jersey.config.client.suppressHttpComplianceValidation");
        if (shcvProperty != null) {
            suppressExceptions = PropertiesHelper.isProperty((Object)shcvProperty);
        }
        if ((entityPresence = METHODS.get((method = request.getMethod()).toUpperCase())) == EntityPresence.MUST_BE_NULL && request.hasEntity()) {
            if (!suppressExceptions) throw new IllegalStateException(LocalizationMessages.ERROR_HTTP_METHOD_ENTITY_NOT_NULL(method));
            LOGGER.warning(LocalizationMessages.ERROR_HTTP_METHOD_ENTITY_NOT_NULL(method));
            return;
        } else {
            if (entityPresence != EntityPresence.MUST_BE_PRESENT || request.hasEntity()) return;
            if (!suppressExceptions) throw new IllegalStateException(LocalizationMessages.ERROR_HTTP_METHOD_ENTITY_NULL(method));
            LOGGER.warning(LocalizationMessages.ERROR_HTTP_METHOD_ENTITY_NULL(method));
        }
    }

    private ClientRequest requestForCall(ClientRequest requestContext) {
        return this.copyRequestContext ? new ClientRequest(requestContext) : requestContext;
    }

    public Response invoke() throws ProcessingException, WebApplicationException {
        final ClientRuntime runtime = this.request().getClientRuntime();
        final RequestScope requestScope = runtime.getRequestScope();
        return (Response)requestScope.runInScope((Producer)new Producer<Response>(){

            public Response call() throws ProcessingException {
                return new InboundJaxrsResponse(runtime.invoke(JerseyInvocation.this.requestForCall(JerseyInvocation.this.requestContext)), requestScope);
            }
        });
    }

    public <T> T invoke(final Class<T> responseType) throws ProcessingException, WebApplicationException {
        if (responseType == null) {
            throw new IllegalArgumentException(LocalizationMessages.RESPONSE_TYPE_IS_NULL());
        }
        final ClientRuntime runtime = this.request().getClientRuntime();
        final RequestScope requestScope = runtime.getRequestScope();
        return (T)requestScope.runInScope(new Producer<T>(){

            public T call() throws ProcessingException {
                try {
                    return JerseyInvocation.this.translate(runtime.invoke(JerseyInvocation.this.requestForCall(JerseyInvocation.this.requestContext)), requestScope, responseType);
                }
                catch (ProcessingException ex) {
                    if (ex.getCause() instanceof WebApplicationException) {
                        throw (WebApplicationException)ex.getCause();
                    }
                    throw ex;
                }
            }
        });
    }

    public <T> T invoke(final GenericType<T> responseType) throws ProcessingException, WebApplicationException {
        if (responseType == null) {
            throw new IllegalArgumentException(LocalizationMessages.RESPONSE_TYPE_IS_NULL());
        }
        final ClientRuntime runtime = this.request().getClientRuntime();
        final RequestScope requestScope = runtime.getRequestScope();
        return (T)requestScope.runInScope(new Producer<T>(){

            public T call() throws ProcessingException {
                try {
                    return JerseyInvocation.this.translate(runtime.invoke(JerseyInvocation.this.requestForCall(JerseyInvocation.this.requestContext)), requestScope, responseType);
                }
                catch (ProcessingException ex) {
                    if (ex.getCause() instanceof WebApplicationException) {
                        throw (WebApplicationException)ex.getCause();
                    }
                    throw ex;
                }
            }
        });
    }

    public Future<Response> submit() {
        final SettableFuture responseFuture = SettableFuture.create();
        this.request().getClientRuntime().submit(this.requestForCall(this.requestContext), new ResponseCallback(){

            @Override
            public void completed(ClientResponse response, RequestScope scope) {
                if (!responseFuture.isCancelled()) {
                    responseFuture.set((Object)new InboundJaxrsResponse(response, scope));
                } else {
                    response.close();
                }
            }

            @Override
            public void failed(ProcessingException error) {
                if (!responseFuture.isCancelled()) {
                    responseFuture.setException((Throwable)error);
                }
            }
        });
        return responseFuture;
    }

    public <T> Future<T> submit(final Class<T> responseType) {
        if (responseType == null) {
            throw new IllegalArgumentException(LocalizationMessages.RESPONSE_TYPE_IS_NULL());
        }
        final SettableFuture responseFuture = SettableFuture.create();
        this.request().getClientRuntime().submit(this.requestForCall(this.requestContext), new ResponseCallback(){

            @Override
            public void completed(ClientResponse response, RequestScope scope) {
                if (responseFuture.isCancelled()) {
                    response.close();
                    return;
                }
                try {
                    responseFuture.set(JerseyInvocation.this.translate(response, scope, responseType));
                }
                catch (ProcessingException ex) {
                    this.failed(ex);
                }
            }

            @Override
            public void failed(ProcessingException error) {
                if (responseFuture.isCancelled()) {
                    return;
                }
                if (error.getCause() instanceof WebApplicationException) {
                    responseFuture.setException(error.getCause());
                } else {
                    responseFuture.setException((Throwable)error);
                }
            }
        });
        return responseFuture;
    }

    private <T> T translate(ClientResponse response, RequestScope scope, Class<T> responseType) throws ProcessingException {
        if (responseType == Response.class) {
            return responseType.cast((Object)new InboundJaxrsResponse(response, scope));
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            try {
                return response.readEntity(responseType);
            }
            catch (ProcessingException ex) {
                if (((Object)((Object)ex)).getClass() == ProcessingException.class) {
                    throw new ResponseProcessingException((Response)new InboundJaxrsResponse(response, scope), ex.getCause());
                }
                throw new ResponseProcessingException((Response)new InboundJaxrsResponse(response, scope), (Throwable)ex);
            }
            catch (WebApplicationException ex) {
                throw new ResponseProcessingException((Response)new InboundJaxrsResponse(response, scope), (Throwable)ex);
            }
            catch (Exception ex) {
                throw new ResponseProcessingException((Response)new InboundJaxrsResponse(response, scope), LocalizationMessages.UNEXPECTED_ERROR_RESPONSE_PROCESSING(), (Throwable)ex);
            }
        }
        throw this.convertToException(new InboundJaxrsResponse(response, scope));
    }

    public <T> Future<T> submit(final GenericType<T> responseType) {
        if (responseType == null) {
            throw new IllegalArgumentException(LocalizationMessages.RESPONSE_TYPE_IS_NULL());
        }
        final SettableFuture responseFuture = SettableFuture.create();
        this.request().getClientRuntime().submit(this.requestForCall(this.requestContext), new ResponseCallback(){

            @Override
            public void completed(ClientResponse response, RequestScope scope) {
                if (responseFuture.isCancelled()) {
                    response.close();
                    return;
                }
                try {
                    responseFuture.set(JerseyInvocation.this.translate(response, scope, responseType));
                }
                catch (ProcessingException ex) {
                    this.failed(ex);
                }
            }

            @Override
            public void failed(ProcessingException error) {
                if (responseFuture.isCancelled()) {
                    return;
                }
                if (error.getCause() instanceof WebApplicationException) {
                    responseFuture.setException(error.getCause());
                } else {
                    responseFuture.setException((Throwable)error);
                }
            }
        });
        return responseFuture;
    }

    private <T> T translate(ClientResponse response, RequestScope scope, GenericType<T> responseType) throws ProcessingException {
        if (responseType.getRawType() == Response.class) {
            return (T)((Object)new InboundJaxrsResponse(response, scope));
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            try {
                return response.readEntity(responseType);
            }
            catch (ProcessingException ex) {
                throw new ResponseProcessingException((Response)new InboundJaxrsResponse(response, scope), ex.getCause() != null ? ex.getCause() : ex);
            }
            catch (WebApplicationException ex) {
                throw new ResponseProcessingException((Response)new InboundJaxrsResponse(response, scope), (Throwable)ex);
            }
            catch (Exception ex) {
                throw new ResponseProcessingException((Response)new InboundJaxrsResponse(response, scope), LocalizationMessages.UNEXPECTED_ERROR_RESPONSE_PROCESSING(), (Throwable)ex);
            }
        }
        throw this.convertToException(new InboundJaxrsResponse(response, scope));
    }

    public <T> Future<T> submit(InvocationCallback<T> callback) {
        return this.submit(null, callback);
    }

    public <T> Future<T> submit(GenericType<T> responseType, final InvocationCallback<T> callback) {
        final SettableFuture responseFuture = SettableFuture.create();
        try {
            Class callbackParamClass;
            Object callbackParamType;
            ReflectionHelper.DeclaringClassInterfacePair pair = ReflectionHelper.getClass(callback.getClass(), InvocationCallback.class);
            if (responseType == null) {
                Type[] typeArguments = ReflectionHelper.getParameterizedTypeArguments((ReflectionHelper.DeclaringClassInterfacePair)pair);
                callbackParamType = typeArguments == null || typeArguments.length == 0 ? Object.class : typeArguments[0];
                callbackParamClass = ReflectionHelper.erasure((Type)callbackParamType);
            } else {
                callbackParamType = responseType.getType();
                callbackParamClass = ReflectionHelper.erasure((Type)responseType.getRawType());
            }
            ResponseCallback responseCallback = new ResponseCallback((Type)callbackParamType){
                final /* synthetic */ Type val$callbackParamType;
                {
                    this.val$callbackParamType = type;
                }

                @Override
                public void completed(ClientResponse response, RequestScope scope) {
                    if (responseFuture.isCancelled()) {
                        response.close();
                        this.failed(new ProcessingException((Throwable)new CancellationException(LocalizationMessages.ERROR_REQUEST_CANCELLED())));
                        return;
                    }
                    if (callbackParamClass == Response.class) {
                        Object result = callbackParamClass.cast((Object)new InboundJaxrsResponse(response, scope));
                        responseFuture.set(result);
                        callback.completed(result);
                    } else if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                        Object result = response.readEntity(new GenericType(this.val$callbackParamType));
                        responseFuture.set(result);
                        callback.completed(result);
                    } else {
                        this.failed(JerseyInvocation.this.convertToException(new InboundJaxrsResponse(response, scope)));
                    }
                }

                @Override
                public void failed(ProcessingException error) {
                    try {
                        if (error.getCause() instanceof WebApplicationException) {
                            responseFuture.setException(error.getCause());
                        } else if (!responseFuture.isCancelled()) {
                            responseFuture.setException((Throwable)error);
                        }
                    }
                    catch (Throwable throwable) {
                        callback.failed(error.getCause() instanceof CancellationException ? error.getCause() : error);
                        throw throwable;
                    }
                    callback.failed(error.getCause() instanceof CancellationException ? error.getCause() : error);
                }
            };
            this.request().getClientRuntime().submit(this.requestForCall(this.requestContext), responseCallback);
        }
        catch (Throwable error) {
            ProcessingException ce;
            if (error instanceof ProcessingException) {
                ce = (ProcessingException)error;
                responseFuture.setException((Throwable)ce);
            } else if (error instanceof WebApplicationException) {
                ce = new ProcessingException(error);
                responseFuture.setException(error);
            } else {
                ce = new ProcessingException(error);
                responseFuture.setException((Throwable)ce);
            }
            callback.failed((Throwable)ce);
        }
        return responseFuture;
    }

    public JerseyInvocation property(String name, Object value) {
        this.requestContext.setProperty(name, value);
        return this;
    }

    private ProcessingException convertToException(Response response) {
        try {
            WebApplicationException webAppException;
            response.bufferEntity();
            int statusCode = response.getStatus();
            Response.Status status = Response.Status.fromStatusCode((int)statusCode);
            if (status == null) {
                Response.Status.Family statusFamily = response.getStatusInfo().getFamily();
                webAppException = this.createExceptionForFamily(response, statusFamily);
            } else {
                switch (status) {
                    case BAD_REQUEST: {
                        webAppException = new BadRequestException(response);
                        break;
                    }
                    case UNAUTHORIZED: {
                        webAppException = new NotAuthorizedException(response);
                        break;
                    }
                    case FORBIDDEN: {
                        webAppException = new ForbiddenException(response);
                        break;
                    }
                    case NOT_FOUND: {
                        webAppException = new NotFoundException(response);
                        break;
                    }
                    case METHOD_NOT_ALLOWED: {
                        webAppException = new NotAllowedException(response);
                        break;
                    }
                    case NOT_ACCEPTABLE: {
                        webAppException = new NotAcceptableException(response);
                        break;
                    }
                    case UNSUPPORTED_MEDIA_TYPE: {
                        webAppException = new NotSupportedException(response);
                        break;
                    }
                    case INTERNAL_SERVER_ERROR: {
                        webAppException = new InternalServerErrorException(response);
                        break;
                    }
                    case SERVICE_UNAVAILABLE: {
                        webAppException = new ServiceUnavailableException(response);
                        break;
                    }
                    default: {
                        Response.Status.Family statusFamily = response.getStatusInfo().getFamily();
                        webAppException = this.createExceptionForFamily(response, statusFamily);
                    }
                }
            }
            return new ResponseProcessingException(response, (Throwable)webAppException);
        }
        catch (Throwable t) {
            return new ResponseProcessingException(response, LocalizationMessages.RESPONSE_TO_EXCEPTION_CONVERSION_FAILED(), t);
        }
    }

    private WebApplicationException createExceptionForFamily(Response response, Response.Status.Family statusFamily) {
        Object webAppException;
        switch (statusFamily) {
            case REDIRECTION: {
                webAppException = new RedirectionException(response);
                break;
            }
            case CLIENT_ERROR: {
                webAppException = new ClientErrorException(response);
                break;
            }
            case SERVER_ERROR: {
                webAppException = new ServerErrorException(response);
                break;
            }
            default: {
                webAppException = new WebApplicationException(response);
            }
        }
        return webAppException;
    }

    ClientRequest request() {
        return this.requestContext;
    }

    private static class AsyncInvoker
    implements javax.ws.rs.client.AsyncInvoker {
        private final Builder builder;

        private AsyncInvoker(Builder request) {
            this.builder = request;
            this.builder.requestContext.setAsynchronous(true);
        }

        public Future<Response> get() {
            return this.method("GET");
        }

        public <T> Future<T> get(Class<T> responseType) {
            return this.method("GET", responseType);
        }

        public <T> Future<T> get(GenericType<T> responseType) {
            return this.method("GET", responseType);
        }

        public <T> Future<T> get(InvocationCallback<T> callback) {
            return this.method("GET", callback);
        }

        public Future<Response> put(Entity<?> entity) {
            return this.method("PUT", entity);
        }

        public <T> Future<T> put(Entity<?> entity, Class<T> responseType) {
            return this.method("PUT", entity, responseType);
        }

        public <T> Future<T> put(Entity<?> entity, GenericType<T> responseType) {
            return this.method("PUT", entity, responseType);
        }

        public <T> Future<T> put(Entity<?> entity, InvocationCallback<T> callback) {
            return this.method("PUT", entity, callback);
        }

        public Future<Response> post(Entity<?> entity) {
            return this.method("POST", entity);
        }

        public <T> Future<T> post(Entity<?> entity, Class<T> responseType) {
            return this.method("POST", entity, responseType);
        }

        public <T> Future<T> post(Entity<?> entity, GenericType<T> responseType) {
            return this.method("POST", entity, responseType);
        }

        public <T> Future<T> post(Entity<?> entity, InvocationCallback<T> callback) {
            return this.method("POST", entity, callback);
        }

        public Future<Response> delete() {
            return this.method("DELETE");
        }

        public <T> Future<T> delete(Class<T> responseType) {
            return this.method("DELETE", responseType);
        }

        public <T> Future<T> delete(GenericType<T> responseType) {
            return this.method("DELETE", responseType);
        }

        public <T> Future<T> delete(InvocationCallback<T> callback) {
            return this.method("DELETE", callback);
        }

        public Future<Response> head() {
            return this.method("HEAD");
        }

        public Future<Response> head(InvocationCallback<Response> callback) {
            return this.method("HEAD", callback);
        }

        public Future<Response> options() {
            return this.method("OPTIONS");
        }

        public <T> Future<T> options(Class<T> responseType) {
            return this.method("OPTIONS", responseType);
        }

        public <T> Future<T> options(GenericType<T> responseType) {
            return this.method("OPTIONS", responseType);
        }

        public <T> Future<T> options(InvocationCallback<T> callback) {
            return this.method("OPTIONS", callback);
        }

        public Future<Response> trace() {
            return this.method("TRACE");
        }

        public <T> Future<T> trace(Class<T> responseType) {
            return this.method("TRACE", responseType);
        }

        public <T> Future<T> trace(GenericType<T> responseType) {
            return this.method("TRACE", responseType);
        }

        public <T> Future<T> trace(InvocationCallback<T> callback) {
            return this.method("TRACE", callback);
        }

        public Future<Response> method(String name) {
            this.builder.requestContext.setMethod(name);
            return new JerseyInvocation(this.builder).submit();
        }

        public <T> Future<T> method(String name, Class<T> responseType) {
            if (responseType == null) {
                throw new IllegalArgumentException(LocalizationMessages.RESPONSE_TYPE_IS_NULL());
            }
            this.builder.requestContext.setMethod(name);
            return new JerseyInvocation(this.builder).submit(responseType);
        }

        public <T> Future<T> method(String name, GenericType<T> responseType) {
            if (responseType == null) {
                throw new IllegalArgumentException(LocalizationMessages.RESPONSE_TYPE_IS_NULL());
            }
            this.builder.requestContext.setMethod(name);
            return new JerseyInvocation(this.builder).submit(responseType);
        }

        public <T> Future<T> method(String name, InvocationCallback<T> callback) {
            this.builder.requestContext.setMethod(name);
            return new JerseyInvocation(this.builder).submit(callback);
        }

        public Future<Response> method(String name, Entity<?> entity) {
            this.builder.requestContext.setMethod(name);
            this.builder.storeEntity(entity);
            return new JerseyInvocation(this.builder).submit();
        }

        public <T> Future<T> method(String name, Entity<?> entity, Class<T> responseType) {
            if (responseType == null) {
                throw new IllegalArgumentException(LocalizationMessages.RESPONSE_TYPE_IS_NULL());
            }
            this.builder.requestContext.setMethod(name);
            this.builder.storeEntity(entity);
            return new JerseyInvocation(this.builder).submit(responseType);
        }

        public <T> Future<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
            if (responseType == null) {
                throw new IllegalArgumentException(LocalizationMessages.RESPONSE_TYPE_IS_NULL());
            }
            this.builder.requestContext.setMethod(name);
            this.builder.storeEntity(entity);
            return new JerseyInvocation(this.builder).submit(responseType);
        }

        public <T> Future<T> method(String name, Entity<?> entity, InvocationCallback<T> callback) {
            this.builder.requestContext.setMethod(name);
            this.builder.storeEntity(entity);
            return new JerseyInvocation(this.builder).submit(callback);
        }
    }

    public static class Builder
    implements Invocation.Builder {
        private final ClientRequest requestContext;

        protected Builder(URI uri, ClientConfig configuration) {
            this.requestContext = new ClientRequest(uri, configuration, (PropertiesDelegate)new MapPropertiesDelegate());
        }

        ClientRequest request() {
            return this.requestContext;
        }

        private void storeEntity(Entity<?> entity) {
            if (entity != null) {
                this.requestContext.variant(entity.getVariant());
                this.requestContext.setEntity(entity.getEntity());
                this.requestContext.setEntityAnnotations(entity.getAnnotations());
            }
        }

        public JerseyInvocation build(String method) {
            this.requestContext.setMethod(method);
            return new JerseyInvocation(this, true);
        }

        public JerseyInvocation build(String method, Entity<?> entity) {
            this.requestContext.setMethod(method);
            this.storeEntity(entity);
            return new JerseyInvocation(this, true);
        }

        public JerseyInvocation buildGet() {
            this.requestContext.setMethod("GET");
            return new JerseyInvocation(this, true);
        }

        public JerseyInvocation buildDelete() {
            this.requestContext.setMethod("DELETE");
            return new JerseyInvocation(this, true);
        }

        public JerseyInvocation buildPost(Entity<?> entity) {
            this.requestContext.setMethod("POST");
            this.storeEntity(entity);
            return new JerseyInvocation(this, true);
        }

        public JerseyInvocation buildPut(Entity<?> entity) {
            this.requestContext.setMethod("PUT");
            this.storeEntity(entity);
            return new JerseyInvocation(this, true);
        }

        public javax.ws.rs.client.AsyncInvoker async() {
            return new AsyncInvoker(this);
        }

        public Builder accept(String ... mediaTypes) {
            this.requestContext.accept(mediaTypes);
            return this;
        }

        public Builder accept(MediaType ... mediaTypes) {
            this.requestContext.accept(mediaTypes);
            return this;
        }

        public Invocation.Builder acceptEncoding(String ... encodings) {
            this.requestContext.getHeaders().addAll((Object)"Accept-Encoding", (Object[])encodings);
            return this;
        }

        public Builder acceptLanguage(Locale ... locales) {
            this.requestContext.acceptLanguage(locales);
            return this;
        }

        public Builder acceptLanguage(String ... locales) {
            this.requestContext.acceptLanguage(locales);
            return this;
        }

        public Builder cookie(Cookie cookie) {
            this.requestContext.cookie(cookie);
            return this;
        }

        public Builder cookie(String name, String value) {
            this.requestContext.cookie(new Cookie(name, value));
            return this;
        }

        public Builder cacheControl(CacheControl cacheControl) {
            this.requestContext.cacheControl(cacheControl);
            return this;
        }

        public Builder header(String name, Object value) {
            MultivaluedMap headers = this.requestContext.getHeaders();
            if (value == null) {
                headers.remove((Object)name);
            } else {
                headers.add((Object)name, value);
            }
            if ("User-Agent".equalsIgnoreCase(name)) {
                this.requestContext.ignoreUserAgent(value == null);
            }
            return this;
        }

        public Builder headers(MultivaluedMap<String, Object> headers) {
            this.requestContext.replaceHeaders(headers);
            return this;
        }

        public Response get() throws ProcessingException {
            return this.method("GET");
        }

        public <T> T get(Class<T> responseType) throws ProcessingException, WebApplicationException {
            return this.method("GET", responseType);
        }

        public <T> T get(GenericType<T> responseType) throws ProcessingException, WebApplicationException {
            return this.method("GET", responseType);
        }

        public Response put(Entity<?> entity) throws ProcessingException {
            return this.method("PUT", entity);
        }

        public <T> T put(Entity<?> entity, Class<T> responseType) throws ProcessingException, WebApplicationException {
            return this.method("PUT", entity, responseType);
        }

        public <T> T put(Entity<?> entity, GenericType<T> responseType) throws ProcessingException, WebApplicationException {
            return this.method("PUT", entity, responseType);
        }

        public Response post(Entity<?> entity) throws ProcessingException {
            return this.method("POST", entity);
        }

        public <T> T post(Entity<?> entity, Class<T> responseType) throws ProcessingException, WebApplicationException {
            return this.method("POST", entity, responseType);
        }

        public <T> T post(Entity<?> entity, GenericType<T> responseType) throws ProcessingException, WebApplicationException {
            return this.method("POST", entity, responseType);
        }

        public Response delete() throws ProcessingException {
            return this.method("DELETE");
        }

        public <T> T delete(Class<T> responseType) throws ProcessingException, WebApplicationException {
            return this.method("DELETE", responseType);
        }

        public <T> T delete(GenericType<T> responseType) throws ProcessingException, WebApplicationException {
            return this.method("DELETE", responseType);
        }

        public Response head() throws ProcessingException {
            return this.method("HEAD");
        }

        public Response options() throws ProcessingException {
            return this.method("OPTIONS");
        }

        public <T> T options(Class<T> responseType) throws ProcessingException, WebApplicationException {
            return this.method("OPTIONS", responseType);
        }

        public <T> T options(GenericType<T> responseType) throws ProcessingException, WebApplicationException {
            return this.method("OPTIONS", responseType);
        }

        public Response trace() throws ProcessingException {
            return this.method("TRACE");
        }

        public <T> T trace(Class<T> responseType) throws ProcessingException, WebApplicationException {
            return this.method("TRACE", responseType);
        }

        public <T> T trace(GenericType<T> responseType) throws ProcessingException, WebApplicationException {
            return this.method("TRACE", responseType);
        }

        public Response method(String name) throws ProcessingException {
            this.requestContext.setMethod(name);
            return new JerseyInvocation(this).invoke();
        }

        public <T> T method(String name, Class<T> responseType) throws ProcessingException, WebApplicationException {
            if (responseType == null) {
                throw new IllegalArgumentException(LocalizationMessages.RESPONSE_TYPE_IS_NULL());
            }
            this.requestContext.setMethod(name);
            return new JerseyInvocation(this).invoke(responseType);
        }

        public <T> T method(String name, GenericType<T> responseType) throws ProcessingException, WebApplicationException {
            if (responseType == null) {
                throw new IllegalArgumentException(LocalizationMessages.RESPONSE_TYPE_IS_NULL());
            }
            this.requestContext.setMethod(name);
            return new JerseyInvocation(this).invoke(responseType);
        }

        public Response method(String name, Entity<?> entity) throws ProcessingException {
            this.requestContext.setMethod(name);
            this.storeEntity(entity);
            return new JerseyInvocation(this).invoke();
        }

        public <T> T method(String name, Entity<?> entity, Class<T> responseType) throws ProcessingException, WebApplicationException {
            if (responseType == null) {
                throw new IllegalArgumentException(LocalizationMessages.RESPONSE_TYPE_IS_NULL());
            }
            this.requestContext.setMethod(name);
            this.storeEntity(entity);
            return new JerseyInvocation(this).invoke(responseType);
        }

        public <T> T method(String name, Entity<?> entity, GenericType<T> responseType) throws ProcessingException, WebApplicationException {
            if (responseType == null) {
                throw new IllegalArgumentException(LocalizationMessages.RESPONSE_TYPE_IS_NULL());
            }
            this.requestContext.setMethod(name);
            this.storeEntity(entity);
            return new JerseyInvocation(this).invoke(responseType);
        }

        public Builder property(String name, Object value) {
            this.requestContext.setProperty(name, value);
            return this;
        }

        public CompletionStageRxInvoker rx() {
            return new JerseyCompletionStageRxInvoker(this, null);
        }

        public CompletionStageRxInvoker rx(ExecutorService executorService) {
            return new JerseyCompletionStageRxInvoker(this, executorService);
        }

        public <T extends RxInvoker> T rx(RxInvokerProvider<T> rxInvokerProvider) {
            if (rxInvokerProvider == null) {
                throw new IllegalArgumentException(LocalizationMessages.NULL_INPUT_PARAMETER("rxInvokerProvider"));
            }
            return this.createRxInvoker(rxInvokerProvider, null);
        }

        public <T extends RxInvoker> T rx(RxInvokerProvider<T> rxInvokerProvider, ExecutorService executorService) {
            if (rxInvokerProvider == null) {
                throw new IllegalArgumentException(LocalizationMessages.NULL_INPUT_PARAMETER("rxInvokerProvider"));
            }
            if (executorService == null) {
                throw new IllegalArgumentException(LocalizationMessages.NULL_INPUT_PARAMETER("executorService"));
            }
            return this.createRxInvoker(rxInvokerProvider, executorService);
        }

        public <T extends RxInvoker> T rx(Class<? extends RxInvokerProvider<T>> clazz) {
            return this.createRxInvoker(clazz, null);
        }

        public <T extends RxInvoker> T rx(Class<? extends RxInvokerProvider<T>> clazz, ExecutorService executorService) {
            if (executorService == null) {
                throw new IllegalArgumentException(LocalizationMessages.NULL_INPUT_PARAMETER("executorService"));
            }
            return this.createRxInvoker(clazz, executorService);
        }

        private <T extends RxInvoker> T createRxInvoker(Class<? extends RxInvokerProvider<T>> clazz, ExecutorService executorService) {
            RxInvokerProvider<T> RxInvokerProvider2;
            if (clazz == null) {
                throw new IllegalArgumentException(LocalizationMessages.NULL_INPUT_PARAMETER("clazz"));
            }
            try {
                RxInvokerProvider2 = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(LocalizationMessages.ERROR_REFLECTION_INSTANCE_CREATE(RxInvokerProvider.class.getSimpleName(), clazz.getName()), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(LocalizationMessages.ERROR_REFLECTION_INSTANCE_CREATE(RxInvokerProvider.class.getSimpleName(), clazz.getName()), e);
            }
            return this.createRxInvoker(RxInvokerProvider2, executorService);
        }

        private <T extends RxInvoker> T createRxInvoker(RxInvokerProvider<T> RxInvokerProvider2, ExecutorService executorService) {
            RxInvoker rxInvoker = RxInvokerProvider2.getRxInvoker((Invocation.Builder)this, executorService);
            if (rxInvoker == null) {
                throw new IllegalStateException(LocalizationMessages.CLIENT_RX_FACTORY_NULL());
            }
            return (T)rxInvoker;
        }

        public NioInvoker nio() {
            throw new UnsupportedOperationException("TODO JAX-RS 2.1: to be implemented");
        }
    }

    private static enum EntityPresence {
        MUST_BE_NULL,
        MUST_BE_PRESENT,
        OPTIONAL;

    }
}

