/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.collection.UnsafeValue;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.Statuses;

class HttpUrlConnector
implements Connector {
    private final HttpUrlConnectorProvider.ConnectionFactory connectionFactory;
    private final int chunkSize;
    private final boolean fixLengthStreaming;
    private final boolean setMethodWorkaround;

    HttpUrlConnector(HttpUrlConnectorProvider.ConnectionFactory connectionFactory, int chunkSize, boolean fixLengthStreaming, boolean setMethodWorkaround) {
        this.connectionFactory = connectionFactory;
        this.chunkSize = chunkSize;
        this.fixLengthStreaming = fixLengthStreaming;
        this.setMethodWorkaround = setMethodWorkaround;
    }

    private static InputStream getInputStream(final HttpURLConnection uc) throws IOException {
        return new InputStream(){
            private final UnsafeValue<InputStream, IOException> in = Values.lazy((UnsafeValue)new UnsafeValue<InputStream, IOException>(){

                public InputStream get() throws IOException {
                    if (uc.getResponseCode() < Response.Status.BAD_REQUEST.getStatusCode()) {
                        return uc.getInputStream();
                    }
                    InputStream ein = uc.getErrorStream();
                    return ein != null ? ein : new ByteArrayInputStream(new byte[0]);
                }
            });

            @Override
            public int read() throws IOException {
                return ((InputStream)this.in.get()).read();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return ((InputStream)this.in.get()).read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return ((InputStream)this.in.get()).read(b, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                return ((InputStream)this.in.get()).skip(n);
            }

            @Override
            public int available() throws IOException {
                return ((InputStream)this.in.get()).available();
            }

            @Override
            public void close() throws IOException {
                ((InputStream)this.in.get()).close();
            }

            @Override
            public void mark(int readLimit) {
                try {
                    ((InputStream)this.in.get()).mark(readLimit);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to retrieve the underlying input stream.", e);
                }
            }

            @Override
            public void reset() throws IOException {
                ((InputStream)this.in.get()).reset();
            }

            @Override
            public boolean markSupported() {
                try {
                    return ((InputStream)this.in.get()).markSupported();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to retrieve the underlying input stream.", e);
                }
            }
        };
    }

    @Override
    public ClientResponse apply(ClientRequest request) {
        try {
            return this._apply(request);
        }
        catch (IOException ex) {
            throw new ProcessingException((Throwable)ex);
        }
    }

    @Override
    public Future<?> apply(final ClientRequest request, final AsyncConnectorCallback callback) {
        return MoreExecutors.sameThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.response(HttpUrlConnector.this._apply(request));
                }
                catch (IOException ex) {
                    callback.failure(new ProcessingException((Throwable)ex));
                }
                catch (Throwable t) {
                    callback.failure(t);
                }
            }
        });
    }

    @Override
    public void close() {
    }

    private ClientResponse _apply(final ClientRequest request) throws IOException {
        Object entity;
        final HttpURLConnection uc = this.connectionFactory.getConnection(request.getUri().toURL());
        uc.setDoInput(true);
        String httpMethod = request.getMethod();
        if (request.resolveProperty("jersey.config.client.httpUrlConnection.setMethodWorkaround", this.setMethodWorkaround).booleanValue()) {
            HttpUrlConnector.setRequestMethodViaJreBugWorkaround(uc, httpMethod);
        } else {
            uc.setRequestMethod(httpMethod);
        }
        uc.setInstanceFollowRedirects(request.resolveProperty("jersey.config.client.followRedirects", true));
        uc.setConnectTimeout(request.resolveProperty("jersey.config.client.connectTimeout", uc.getConnectTimeout()));
        uc.setReadTimeout(request.resolveProperty("jersey.config.client.readTimeout", uc.getReadTimeout()));
        if (uc instanceof HttpsURLConnection) {
            HttpsURLConnection suc = (HttpsURLConnection)uc;
            JerseyClient client = request.getClient();
            HostnameVerifier verifier = client.getHostnameVerifier();
            if (verifier != null) {
                suc.setHostnameVerifier(verifier);
            }
            suc.setSSLSocketFactory(client.getSslContext().getSocketFactory());
        }
        if ((entity = request.getEntity()) != null) {
            Logger logger;
            RequestEntityProcessing entityProcessing = (RequestEntityProcessing)((Object)request.resolveProperty("jersey.config.client.request.entity.processing", RequestEntityProcessing.class));
            if (entityProcessing == null || entityProcessing != RequestEntityProcessing.BUFFERED) {
                int length = request.getLength();
                if (this.fixLengthStreaming && length > 0) {
                    uc.setFixedLengthStreamingMode(length);
                } else if (entityProcessing == RequestEntityProcessing.CHUNKED) {
                    uc.setChunkedStreamingMode(this.chunkSize);
                }
            }
            uc.setDoOutput(true);
            if ("GET".equalsIgnoreCase(httpMethod) && (logger = Logger.getLogger(HttpUrlConnector.class.getName())).isLoggable(Level.INFO)) {
                logger.log(Level.INFO, LocalizationMessages.HTTPURLCONNECTION_REPLACES_GET_WITH_ENTITY());
            }
            request.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                public OutputStream getOutputStream(int contentLength) throws IOException {
                    HttpUrlConnector.this.setOutboundHeaders((MultivaluedMap<String, String>)request.getStringHeaders(), uc);
                    return uc.getOutputStream();
                }
            });
            request.writeEntity();
        } else {
            this.setOutboundHeaders((MultivaluedMap<String, String>)request.getStringHeaders(), uc);
        }
        int code = uc.getResponseCode();
        String reasonPhrase = uc.getResponseMessage();
        Response.StatusType status = reasonPhrase == null ? Statuses.from((int)code) : Statuses.from((int)code, (String)reasonPhrase);
        ClientResponse responseContext = new ClientResponse(status, request);
        responseContext.headers(Maps.filterKeys(uc.getHeaderFields(), (Predicate)Predicates.notNull()));
        responseContext.setEntityStream(HttpUrlConnector.getInputStream(uc));
        return responseContext;
    }

    private void setOutboundHeaders(MultivaluedMap<String, String> headers, HttpURLConnection uc) {
        for (Map.Entry header : headers.entrySet()) {
            List headerValues = (List)header.getValue();
            if (headerValues.size() == 1) {
                uc.setRequestProperty((String)header.getKey(), (String)headerValues.get(0));
                continue;
            }
            StringBuilder b = new StringBuilder();
            boolean add = false;
            for (Object value : headerValues) {
                if (add) {
                    b.append(',');
                }
                add = true;
                b.append(value);
            }
            uc.setRequestProperty((String)header.getKey(), b.toString());
        }
    }

    private static void setRequestMethodViaJreBugWorkaround(final HttpURLConnection httpURLConnection, final String method) {
        try {
            httpURLConnection.setRequestMethod(method);
        }
        catch (ProtocolException pe) {
            try {
                final Class<?> httpURLConnectionClass = httpURLConnection.getClass();
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws NoSuchFieldException, IllegalAccessException {
                        Field methodField = httpURLConnectionClass.getSuperclass().getDeclaredField("method");
                        methodField.setAccessible(true);
                        methodField.set(httpURLConnection, method);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
    }

    @Override
    public String getName() {
        return "HttpUrlConnection " + (String)AccessController.doPrivileged(PropertiesHelper.getSystemProperty((String)"java.version"));
    }
}

