/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util.collection;

import java.lang.reflect.Type;
import org.glassfish.jersey.internal.util.collection.Pair;

public final class ClassTypePair
implements Pair<Class<?>, Type> {
    private final Type type;
    private final Class<?> rawClass;

    private ClassTypePair(Class<?> c, Type t) {
        this.type = t;
        this.rawClass = c;
    }

    @Override
    public Class<?> left() {
        return this.rawClass;
    }

    @Override
    public Type right() {
        return this.type;
    }

    public Class<?> rawClass() {
        return this.rawClass;
    }

    public Type type() {
        return this.type;
    }

    public static ClassTypePair of(Class<?> rawClass) {
        return new ClassTypePair(rawClass, rawClass);
    }

    public static ClassTypePair of(Class<?> rawClass, Type type) {
        return new ClassTypePair(rawClass, type);
    }
}

