/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.RequestHeaders;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;
import org.glassfish.jersey.message.internal.Request;

final class JaxrsRequestBuilderView
implements Request.RequestBuilder {
    private Request.Builder wrapped;

    public JaxrsRequestBuilderView(Request.Builder wrapped) {
        this.wrapped = wrapped;
    }

    static Request.Builder unwrap(Request.RequestBuilder builder) {
        if (builder instanceof JaxrsRequestBuilderView) {
            return ((JaxrsRequestBuilderView)builder).wrapped;
        }
        throw new IllegalArgumentException(String.format("Request builder class type '%s' not supported.", builder.getClass().getName()));
    }

    public JaxrsRequestBuilderView redirect(String uri) {
        this.wrapped.uri(uri);
        return this;
    }

    public JaxrsRequestBuilderView redirect(URI uri) {
        this.wrapped.uri(uri);
        return this;
    }

    public JaxrsRequestBuilderView redirect(UriBuilder uri) {
        this.wrapped.uri(uri.build(new Object[0]));
        return this;
    }

    public JaxrsRequestBuilderView method(String httpMethod) {
        this.wrapped.method(httpMethod);
        return this;
    }

    public JaxrsRequestBuilderView entity(Object entity) {
        this.wrapped.content(entity);
        return this;
    }

    public JaxrsRequestBuilderView clone() {
        return new JaxrsRequestBuilderView(this.wrapped.clone());
    }

    public Request build() {
        return this.wrapped.build().toJaxrsRequest();
    }

    public JaxrsRequestBuilderView accept(MediaType ... types) {
        this.wrapped.headers("Accept", types);
        return this;
    }

    public JaxrsRequestBuilderView accept(String ... types) {
        this.wrapped.headers("Accept", types);
        return this;
    }

    public JaxrsRequestBuilderView acceptLanguage(Locale ... locales) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JaxrsRequestBuilderView acceptLanguage(String ... locales) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JaxrsRequestBuilderView cookie(Cookie cookie) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JaxrsRequestBuilderView allow(String ... methods) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JaxrsRequestBuilderView allow(Set<String> methods) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JaxrsRequestBuilderView cacheControl(CacheControl cacheControl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JaxrsRequestBuilderView encoding(String encoding) {
        this.headerSingle("Content-Encoding", encoding);
        return this;
    }

    public JaxrsRequestBuilderView header(String name, Object value) {
        return this.header(name, value, false);
    }

    public JaxrsRequestBuilderView headerSingle(String name, Object value) {
        return this.header(name, value, true);
    }

    public JaxrsRequestBuilderView header(String name, Object value, boolean single) {
        if (value != null) {
            if (single) {
                this.wrapped.replace(name, Collections.singleton(value));
            } else {
                this.wrapped.header(name, value);
            }
        } else {
            this.wrapped.remove(name);
        }
        return this;
    }

    public JaxrsRequestBuilderView replaceAll(RequestHeaders headers) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JaxrsRequestBuilderView language(String language) {
        this.headerSingle("Content-Language", language);
        return this;
    }

    public JaxrsRequestBuilderView language(Locale language) {
        this.headerSingle("Content-Language", language);
        return this;
    }

    public JaxrsRequestBuilderView type(MediaType type) {
        this.headerSingle("Content-Type", type);
        return this;
    }

    public JaxrsRequestBuilderView type(String type) {
        return this.type(type == null ? null : MediaType.valueOf((String)type));
    }

    public JaxrsRequestBuilderView variant(Variant variant) {
        if (variant == null) {
            this.type((MediaType)null);
            this.language((String)null);
            this.encoding(null);
            return this;
        }
        this.type(variant.getMediaType());
        this.language(variant.getLanguage());
        this.encoding(variant.getEncoding());
        return this;
    }
}

