/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.TypeLiteral;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.internal.util.collection.InstanceTypePair;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.AbstractMutableMessage;
import org.glassfish.jersey.message.internal.CompletableReader;
import org.glassfish.jersey.message.internal.Entity;
import org.jvnet.hk2.annotations.Inject;

class MutableEntity
implements Entity,
Entity.Builder<MutableEntity> {
    private static final Logger LOGGER = Logger.getLogger(MutableEntity.class.getName());
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final InputStream EMPTY = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    private InputStream contentStream;
    private InstanceTypePair<?> instanceType;
    private AbstractMutableMessage<?> message;
    @Inject
    protected MessageBodyWorkers workers;

    public static MutableEntity empty(AbstractMutableMessage<?> message) {
        return new MutableEntity(message, EMPTY);
    }

    public MutableEntity(AbstractMutableMessage<?> message, InputStream content) {
        this.message = message;
        this.contentStream = content;
    }

    public MutableEntity(AbstractMutableMessage<?> message, InstanceTypePair<?> instanceType) {
        this.message = message;
        this.instanceType = instanceType;
    }

    public MutableEntity(AbstractMutableMessage<?> message, MutableEntity that) {
        this.message = message;
        this.instanceType = that.instanceType;
        this.workers = that.workers;
    }

    @Override
    public boolean isEmpty() {
        if (this.contentStream == null) {
            return this.instanceType == null;
        }
        try {
            if (this.contentStream.available() > 0) {
                return false;
            }
            if (this.contentStream.markSupported()) {
                this.contentStream.mark(1);
                int i = this.contentStream.read();
                this.contentStream.reset();
                return i == -1;
            }
            return true;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Object content() {
        return this.content(Object.class);
    }

    @Override
    public <T> T content(Class<T> rawType) {
        Class<T> genericSuperclass = rawType.getGenericSuperclass();
        return this.content(rawType, genericSuperclass instanceof ParameterizedType ? genericSuperclass : rawType);
    }

    private <T> T content(Class<T> rawType, Type type) {
        boolean typeIsAssignableFromMyInstance;
        boolean bl = typeIsAssignableFromMyInstance = this.instanceType != null && rawType.isAssignableFrom(this.instanceType.instance().getClass());
        if (typeIsAssignableFromMyInstance) {
            return rawType.cast(this.instanceType.instance());
        }
        MediaType mediaType = this.getMsgContentType();
        if (this.instanceType != null) {
            Type myInstanceType = this.instanceType.type();
            Object myInstance = this.instanceType.instance();
            if (myInstanceType == null || this.workers == null || myInstance == null) {
                return null;
            }
            MessageBodyWriter<?> writer = this.workers.getMessageBodyWriter(myInstance.getClass(), myInstanceType, EMPTY_ANNOTATIONS, mediaType);
            if (writer == null) {
                return null;
            }
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                writer.writeTo(this.instanceType.instance(), myInstanceType.getClass(), myInstanceType, EMPTY_ANNOTATIONS, mediaType, null, (OutputStream)baos);
                baos.close();
                this.contentStream = new ByteArrayInputStream(baos.toByteArray());
            }
            catch (IOException ex) {
                Logger.getLogger(MutableEntity.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (WebApplicationException ex) {
                Logger.getLogger(MutableEntity.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.workers == null) {
            return null;
        }
        MessageBodyReader<T> br = this.workers.getMessageBodyReader(rawType, type, EMPTY_ANNOTATIONS, mediaType);
        if (br == null) {
            return null;
        }
        try {
            Object t = br.readFrom(rawType, type, EMPTY_ANNOTATIONS, mediaType, this.message.toJaxrsHeaderMap(), this.contentStream);
            if (br instanceof CompletableReader) {
                t = ((CompletableReader)br).complete(t);
            }
            if (!(t instanceof Closeable)) {
                this.contentStream.close();
            }
            this.instanceType = InstanceTypePair.of(t);
            return (T)t;
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Error reading entity from input stream", ex);
            return null;
        }
    }

    private MediaType getMsgContentType() {
        if (this.message == null) {
            return null;
        }
        String result = this.message.header("Content-Type");
        if (result == null || result.isEmpty()) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        return MediaType.valueOf((String)result);
    }

    @Override
    public <T> T content(TypeLiteral<T> type) {
        return this.content(type.getRawType(), type.getType());
    }

    @Override
    public Type type() {
        if (this.instanceType != null) {
            return this.instanceType.type();
        }
        return null;
    }

    @Override
    public MutableEntity content(Object content) {
        if (content instanceof InputStream) {
            this.instanceType = null;
            this.contentStream = (InputStream)InputStream.class.cast(content);
            return this;
        }
        this.invalidateContentStream();
        this.instanceType = content != null ? InstanceTypePair.of(content) : null;
        return this;
    }

    @Override
    public MutableEntity content(Object content, Type type) {
        this.invalidateContentStream();
        this.instanceType = content != null ? InstanceTypePair.of(content, type) : null;
        return this;
    }

    @Override
    public <T> MutableEntity content(Object content, TypeLiteral<T> type) {
        this.invalidateContentStream();
        this.instanceType = content != null ? InstanceTypePair.of(content, type.getType()) : null;
        return this;
    }

    public MutableEntity workers(MessageBodyWorkers workers) {
        this.workers = workers;
        return this;
    }

    public MessageBodyWorkers workers() {
        return this.workers;
    }

    private void invalidateContentStream() {
        if (this.contentStream != null) {
            try {
                this.contentStream.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Error closing content input stream", ex);
            }
            this.contentStream = null;
        }
    }
}

