/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.net.URI;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.JaxrsRequestBuilderView;
import org.glassfish.jersey.message.internal.JaxrsRequestHeadersView;
import org.glassfish.jersey.message.internal.JaxrsRequestView;
import org.glassfish.jersey.message.internal.MutableRequest;

public final class Requests {
    public static Request.RequestBuilder from(URI baseUri, URI requestUri, String method) {
        return new MutableRequest(baseUri, requestUri, method).toJaxrsRequestBuilder();
    }

    public static Request.RequestBuilder from(URI requestUri, String method) {
        return new MutableRequest(null, requestUri, method).toJaxrsRequestBuilder();
    }

    public static Request.RequestBuilder from(String baseUri, String requestUri, String method) {
        return new MutableRequest(baseUri, requestUri, method).toJaxrsRequestBuilder();
    }

    public static Request.RequestBuilder from(String requestUri, String method) {
        return new MutableRequest(null, requestUri, method).toJaxrsRequestBuilder();
    }

    public static Request.RequestBuilder from(Request request) {
        return new MutableRequest(JaxrsRequestView.unwrap(request)).toJaxrsRequestBuilder();
    }

    public static Request.RequestBuilder toBuilder(Request request) {
        return JaxrsRequestView.unwrap(request).toBuilder().toJaxrsRequestBuilder();
    }

    public static String relativePath(Request request) {
        return JaxrsRequestView.unwrap(request).relativePath(true);
    }

    public static String relativePath(Request request, boolean decode) {
        return JaxrsRequestView.unwrap(request).relativePath(decode);
    }

    public static URI baseUri(Request request) {
        return JaxrsRequestView.unwrap(request).baseUri();
    }

    public static HttpHeaders httpHeaders(Request request) {
        return JaxrsRequestHeadersView.unwrap(request.getHeaders());
    }

    public static void setMessageWorkers(Request.RequestBuilder requestBuilder, MessageBodyWorkers workers) {
        JaxrsRequestBuilderView.unwrap(requestBuilder).workers(workers);
    }

    public static MessageBodyWorkers getMessageWorkers(Request request) {
        return JaxrsRequestView.unwrap(request).workers();
    }
}

