/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.TypeLiteral;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.message.internal.Responses;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.FilteringInflector;
import org.glassfish.jersey.process.internal.InflectorNotFoundException;
import org.glassfish.jersey.process.internal.RequestProcessor;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.SuspendableInflectorAdapter;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.jvnet.hk2.annotations.Inject;

public class RequestInvoker
implements Inflector<Request, ListenableFuture<Response>> {
    private static final Callback EMPTY_CALLBACK = new Callback(){

        @Override
        public void result(Response response) {
        }

        @Override
        public void failure(Throwable exception) {
        }
    };
    @Inject
    private RequestScope requestScope;
    @Inject
    private RequestProcessor requestProcessor;
    @Inject
    private SuspendableInflectorAdapter.Builder suspendableInflectorBuilder;
    @Inject
    private FilteringInflector.Builder filteringInflectorBuilder;
    @Inject
    private ResponseProcessor.Builder responseProcessorBuilder;
    @Inject
    private Services services;
    private final ExecutorService requestingExecutor;
    private final ExecutorService respondingExecutor;

    public RequestInvoker() {
        this.requestingExecutor = MoreExecutors.sameThreadExecutor();
        this.respondingExecutor = MoreExecutors.sameThreadExecutor();
    }

    public RequestInvoker(RequestScope requestScope, RequestProcessor requestProcessor, SuspendableInflectorAdapter.Builder suspendableInflectorBuilder, ResponseProcessor.Builder responseProcessorBuilder, ExecutorService requestingExecutor, ExecutorService respondingExecutor) {
        this.requestScope = requestScope;
        this.requestProcessor = requestProcessor;
        this.suspendableInflectorBuilder = suspendableInflectorBuilder;
        this.responseProcessorBuilder = responseProcessorBuilder;
        this.requestingExecutor = requestingExecutor;
        this.respondingExecutor = respondingExecutor;
    }

    @Override
    public ListenableFuture<Response> apply(Request request) {
        return this.apply(request, EMPTY_CALLBACK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Response> apply(final Request request, final Callback callback) {
        Callable<ListenableFuture<Response>> requester = new Callable<ListenableFuture<Response>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ListenableFuture<Response> call() {
                Pair<Request, Optional<Inflector<Request, Response>>> result;
                final Ref workersRef = (Ref)RequestInvoker.this.services.forContract((TypeLiteral)new TypeLiteral<Ref<MessageBodyWorkers>>(){}).get();
                Request.RequestBuilder rb = Requests.toBuilder(request);
                Requests.setMessageWorkers(rb, (MessageBodyWorkers)workersRef.get());
                Request requestWithWorkers = rb.build();
                try {
                    result = RequestInvoker.this.requestProcessor.apply(requestWithWorkers);
                }
                catch (WebApplicationException wae) {
                    result = Tuples.of(requestWithWorkers, Optional.of((Object)new Inflector<Request, Response>(){

                        @Override
                        public Response apply(Request data) {
                            return wae.getResponse();
                        }
                    }));
                }
                final Optional<Inflector<Request, Response>> inflector = result.right();
                if (!inflector.isPresent()) {
                    throw new InflectorNotFoundException("Terminal stage did not provide an inflector");
                }
                Inflector<Request, Response> workersAwareResponseInflector = new Inflector<Request, Response>(){

                    @Override
                    public Response apply(Request data) {
                        Response originalResponse = (Response)((Inflector)inflector.get()).apply(data);
                        if (originalResponse != null) {
                            Response.ResponseBuilder rb = Responses.toBuilder(originalResponse);
                            Responses.setMessageWorkers(rb, (MessageBodyWorkers)workersRef.get());
                            return rb.build();
                        }
                        return null;
                    }
                };
                SuspendableInflectorAdapter suspendableInflector = RequestInvoker.this.suspendableInflectorBuilder.build(RequestInvoker.this.filteringInflectorBuilder.build(workersAwareResponseInflector));
                ListenableFuture<Response> response = null;
                try {
                    response = suspendableInflector.apply(result.left());
                    return response;
                }
                finally {
                    ExceptionMappers exceptionMappers = (ExceptionMappers)RequestInvoker.this.services.forContract(ExceptionMappers.class).get();
                    ResponseProcessor responseProcessor = RequestInvoker.this.responseProcessorBuilder.build(callback, response, suspendableInflector, exceptionMappers);
                    suspendableInflector.pushRequestScope(RequestInvoker.this.requestScope.takeSnapshot());
                    response.addListener((Runnable)responseProcessor, (Executor)RequestInvoker.this.respondingExecutor);
                    return responseProcessor;
                }
            }
        };
        try {
            try {
                return this.requestingExecutor.submit(requester).get();
            }
            catch (InterruptedException ex) {
                throw new ProcessingException(LocalizationMessages.REQUEST_EXECUTION_INTERRUPTED(), ex);
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof ProcessingException) {
                    throw (ProcessingException)cause;
                }
                throw new ProcessingException(LocalizationMessages.REQUEST_EXECUTION_FAILED(), cause);
            }
        }
        catch (ProcessingException ex) {
            try {
                SettableFuture failedResponse = SettableFuture.create();
                failedResponse.setException((Throwable)ex);
                SettableFuture settableFuture = failedResponse;
                return settableFuture;
            }
            finally {
                callback.failure(ex);
            }
        }
    }

    public static interface InvocationContext {
        public void pushRequestScope(RequestScope.Snapshot var1);

        public RequestScope.Snapshot popRequestScope();

        public Status status();

        public void resume(Response var1);

        public void resume(Throwable var1);

        public Future<?> suspend();

        public Future<?> suspend(long var1);

        public Future<?> suspend(long var1, TimeUnit var3);

        public long suspesionTimeout();

        public void setResponse(Response var1);

        public Response getResponse();

        public static enum Status {
            RUNNING,
            CANCELLED,
            SUSPENDED,
            RESUMED;

        }
    }

    public static interface Callback {
        public void result(Response var1);

        public void failure(Throwable var1);
    }
}

