/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.hk2.Provider;
import org.glassfish.hk2.Scope;
import org.glassfish.hk2.ScopeInstance;
import org.glassfish.jersey.internal.inject.AbstractModule;

public class RequestScope
implements Scope {
    private final ThreadLocal<Instance> currentScopeInstance = new ThreadLocal();

    public ScopeInstance current() {
        return this.getCurrentScopeInstance();
    }

    private Instance getCurrentScopeInstance() throws IllegalStateException {
        Instance threadLocalCopy = this.currentScopeInstance.get();
        Preconditions.checkState((threadLocalCopy != null ? 1 : 0) != 0, (Object)"Not inside a request scope.");
        return threadLocalCopy;
    }

    public Snapshot takeSnapshot() throws IllegalStateException {
        return new Snapshot(this.getCurrentScopeInstance());
    }

    public boolean isActive() {
        return this.currentScopeInstance.get() != null;
    }

    public void enter() throws IllegalStateException {
        Preconditions.checkState((this.currentScopeInstance.get() == null ? 1 : 0) != 0, (Object)"A scoped block is already in progress");
        this.currentScopeInstance.set(new Instance());
    }

    public void enter(Snapshot snapshot) throws IllegalStateException {
        Preconditions.checkState((this.currentScopeInstance.get() == null ? 1 : 0) != 0, (Object)"A scoped block is already in progress");
        this.currentScopeInstance.set(snapshot.scopeInstance);
    }

    public void exit() throws IllegalStateException {
        Instance threadLocalCopy = this.currentScopeInstance.get();
        Preconditions.checkState((threadLocalCopy != null ? 1 : 0) != 0, (Object)"No scoped block in progress");
        this.currentScopeInstance.remove();
        threadLocalCopy.release();
    }

    public static final class Snapshot {
        private final Instance scopeInstance;

        private Snapshot(Instance instance) {
            this.scopeInstance = instance.snapshot();
        }
    }

    private static final class Instance
    implements ScopeInstance {
        private final Map<Provider<?>, Object> store = new HashMap();
        private final AtomicInteger referenceCounter = new AtomicInteger(1);

        private Instance() {
        }

        public <T> T get(Provider<T> inhabitant) {
            return (T)this.store.get(inhabitant);
        }

        public <T> T put(Provider<T> inhabitant, T value) {
            Preconditions.checkState((!this.store.containsKey(inhabitant) ? 1 : 0) != 0, (String)"An instance for the provider %s was already seeded in this scope. Old instance: %s New instance: %s", (Object[])new Object[]{inhabitant, this.store.get(inhabitant), value});
            return (T)this.store.put(inhabitant, value);
        }

        public <T> boolean contains(Provider<T> provider) {
            return this.store.containsKey(provider);
        }

        public Instance snapshot() {
            this.referenceCounter.incrementAndGet();
            return this;
        }

        public void release() {
            if (this.referenceCounter.decrementAndGet() < 1) {
                this.store.clear();
            }
        }
    }

    public static class Module
    extends AbstractModule {
        @Override
        protected void configure() {
            RequestScope requestScope = new RequestScope();
            this.bind(RequestScope.class, new Class[0]).toInstance((Object)requestScope);
        }
    }
}

