/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.internal.CallbackInvocationException;
import org.glassfish.jersey.process.internal.ExceptionMapper;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Responder;
import org.glassfish.jersey.process.internal.StagingContext;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.jvnet.hk2.annotations.Inject;

public final class ResponseProcessor
extends AbstractFuture<Response>
implements Runnable,
RequestInvoker.Callback {
    private final RequestInvoker.Callback callback;
    private final ListenableFuture<Response> inflectedResponse;
    private final RequestInvoker.InvocationContext invocationContext;
    private final RequestScope requestScope;
    private final ExceptionMappers exceptionMappers;
    private final Factory<RespondingContext> respondingCtxProvider;
    private final Factory<StagingContext<Response>> responseStagingCtxProvider;

    private ResponseProcessor(RequestInvoker.Callback callback, ListenableFuture<Response> inflectedResponse, RequestInvoker.InvocationContext invocationContext, RequestScope requestScope, ExceptionMappers exceptionMappers, Factory<RespondingContext> respondingCtxProvider, Factory<StagingContext<Response>> responseStagingCtxProvider) {
        this.callback = callback;
        this.inflectedResponse = inflectedResponse;
        this.invocationContext = invocationContext;
        this.requestScope = requestScope;
        this.exceptionMappers = exceptionMappers;
        this.respondingCtxProvider = respondingCtxProvider;
        this.responseStagingCtxProvider = responseStagingCtxProvider;
    }

    @Override
    public void run() {
        block10: {
            Response response = null;
            try {
                response = (Response)this.inflectedResponse.get();
            }
            catch (ExecutionException ex) {
                try {
                    response = this.tryToMapException(ex.getCause());
                }
                catch (Exception ex2) {
                    this.failure(ex2.getCause());
                }
                if (response == null) {
                    this.failure(ex.getCause());
                    return;
                }
            }
            catch (Exception ex) {
                this.failure(ex.getCause());
                return;
            }
            try {
                this.result(response);
            }
            catch (Exception ex) {
                try {
                    response = this.tryToMapException(ex.getCause());
                }
                catch (Exception ex2) {
                    this.failure(ex2.getCause());
                    return;
                }
                if (response != null) break block10;
                this.failure(ex.getCause());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void result(Response response) {
        if (this.requestScope.isActive()) {
            this._result(response);
        } else {
            try {
                this.requestScope.enter(this.invocationContext.popRequestScope());
                this._result(response);
            }
            finally {
                this.requestScope.exit();
            }
        }
    }

    private void _result(Response response) {
        Optional<Responder> responder = ((RespondingContext)this.respondingCtxProvider.get()).createStageChain();
        if (responder.isPresent()) {
            StagingContext context = (StagingContext)this.responseStagingCtxProvider.get();
            Pair<Response, Optional<Responder>> continuation = Tuples.of(response, responder);
            while (continuation.right().isPresent()) {
                Responder next = (Responder)continuation.right().get();
                context.beforeStage(next, continuation.left());
                continuation = next.apply(continuation.left());
                context.afterStage(next, continuation.left());
            }
            response = continuation.left();
        }
        this.tryInvokeCallback(response);
        super.set((Object)response);
    }

    private Response tryToMapException(Throwable cause) throws Exception {
        javax.ws.rs.ext.ExceptionMapper<?> mapper;
        if (!(cause instanceof MappableException)) {
            return null;
        }
        Response response = null;
        if ((cause = cause.getCause()) instanceof WebApplicationException) {
            response = ((WebApplicationException)cause).getResponse();
        }
        if (!(response != null && response.hasEntity() || this.exceptionMappers == null || (mapper = this.exceptionMappers.find(cause.getClass())) == null)) {
            response = mapper.toResponse(cause);
        }
        return response;
    }

    @Override
    public void failure(Throwable exception) {
        super.setException(exception);
        if (!(exception instanceof CallbackInvocationException)) {
            this.tryInvokeCallback(exception);
        }
    }

    private void tryInvokeCallback(Response response) {
        try {
            this.callback.result(response);
        }
        catch (Exception ex) {
            throw new CallbackInvocationException(ex);
        }
    }

    private void tryInvokeCallback(Throwable exception) {
        try {
            this.callback.failure(exception);
        }
        catch (Exception ex) {
            throw new CallbackInvocationException(ex);
        }
    }

    public static class Builder {
        @Inject
        private RequestScope requestScope;
        @Inject
        private Factory<RespondingContext> respondingCtxProvider;
        @Inject
        private Factory<StagingContext<Response>> responseStagingCtxProvider;

        public Builder(RequestScope requestScope, ExceptionMapper<Throwable> exceptionMapper, Factory<RespondingContext> respondingCtxProvider, Factory<StagingContext<Response>> responseStagingCtxProvider) {
            this.requestScope = requestScope;
            this.respondingCtxProvider = respondingCtxProvider;
            this.responseStagingCtxProvider = responseStagingCtxProvider;
        }

        public Builder() {
        }

        public ResponseProcessor build(RequestInvoker.Callback callback, ListenableFuture<Response> response, RequestInvoker.InvocationContext invocationContext, ExceptionMappers exceptionMappers) {
            return new ResponseProcessor(callback, response, invocationContext, this.requestScope, exceptionMappers, this.respondingCtxProvider, this.responseStagingCtxProvider);
        }
    }

    public static interface RespondingContext {
        public void push(Function<Response, Response> var1);

        public Optional<Responder> createStageChain();
    }
}

