/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.Inflecting;
import org.glassfish.jersey.process.internal.LinearAcceptor;
import org.glassfish.jersey.process.internal.Responder;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.TreeAcceptor;

public final class Stages {
    private Stages() {
    }

    public static Pair<Request, Iterator<TreeAcceptor>> terminalTreeContinuation(Request request) {
        return Tuples.of(request, Iterators.emptyIterator());
    }

    public static Pair<Request, Optional<LinearAcceptor>> terminalLinearContinuation(Request request) {
        return Tuples.of(request, Optional.absent());
    }

    public static TreeAcceptor asTreeAcceptor(Inflector<Request, Response> inflector) {
        return new InflectingTreeAcceptor(inflector);
    }

    public static LinearAcceptor asLinearAcceptor(Inflector<Request, Response> inflector) {
        return new InflectingLinearAcceptor(inflector);
    }

    public static <DATA, RESULT> Optional<Inflector<DATA, RESULT>> extractInflector(Stage<DATA, ?> stage) {
        if (stage instanceof Inflecting) {
            return Optional.fromNullable(((Inflecting)((Object)stage)).inflector());
        }
        return Optional.absent();
    }

    public static TreeAcceptor.Builder acceptingTree(Function<Request, Request> transformation) {
        return new TreeAcceptorBuilder(transformation);
    }

    public static LinearAcceptor.Builder acceptingChain(Function<Request, Request> transformation) {
        return new LinearAcceptorChainBuilder(transformation);
    }

    public static Responder.Builder respondingChain(Function<Response, Response> transformation) {
        return new ResponderChainBuilder(transformation);
    }

    private static class LinkedResponder
    implements Responder {
        private final Optional<Responder> nextStage;
        private final Function<Response, Response> transformation;

        public LinkedResponder(Function<Response, Response> transformation, Responder nextStage) {
            this.nextStage = Optional.of((Object)nextStage);
            this.transformation = transformation;
        }

        public LinkedResponder(Function<Response, Response> transformation) {
            this.nextStage = Optional.absent();
            this.transformation = transformation;
        }

        @Override
        public Pair<Response, Optional<Responder>> apply(Response Response2) {
            return Tuples.of(this.transformation.apply((Object)Response2), this.nextStage);
        }
    }

    private static class ResponderChainBuilder
    implements Responder.Builder {
        private final Deque<Function<Response, Response>> transformations = new LinkedList<Function<Response, Response>>();

        private ResponderChainBuilder(Function<Response, Response> transformation) {
            this.transformations.push(transformation);
        }

        @Override
        public ResponderChainBuilder to(Function<Response, Response> transformation) {
            this.transformations.push(transformation);
            return this;
        }

        @Override
        public Responder build(Responder stage) {
            Function<Response, Response> t;
            while ((t = this.transformations.poll()) != null) {
                stage = new LinkedResponder(t, stage);
            }
            return stage;
        }

        @Override
        public Responder build() {
            Function<Response, Response> t;
            LinkedResponder stage = new LinkedResponder(this.transformations.poll());
            while ((t = this.transformations.poll()) != null) {
                stage = new LinkedResponder(t, stage);
            }
            return stage;
        }
    }

    private static class LinkedLinearAcceptor
    implements LinearAcceptor {
        private final Optional<LinearAcceptor> nextStage;
        private final Function<Request, Request> transformation;

        public LinkedLinearAcceptor(Function<Request, Request> transformation, LinearAcceptor nextStage) {
            this.nextStage = Optional.of((Object)nextStage);
            this.transformation = transformation;
        }

        public LinkedLinearAcceptor(Function<Request, Request> transformation) {
            this.nextStage = Optional.absent();
            this.transformation = transformation;
        }

        @Override
        public Pair<Request, Optional<LinearAcceptor>> apply(Request request) {
            return Tuples.of(this.transformation.apply((Object)request), this.nextStage);
        }
    }

    private static class LinearAcceptorChainBuilder
    implements LinearAcceptor.Builder {
        private final Deque<Function<Request, Request>> transformations = new LinkedList<Function<Request, Request>>();

        private LinearAcceptorChainBuilder(Function<Request, Request> transformation) {
            this.transformations.push(transformation);
        }

        @Override
        public LinearAcceptorChainBuilder to(Function<Request, Request> transformation) {
            this.transformations.push(transformation);
            return this;
        }

        @Override
        public LinearAcceptor build(LinearAcceptor stage) {
            Function<Request, Request> t;
            while ((t = this.transformations.poll()) != null) {
                stage = new LinkedLinearAcceptor(t, stage);
            }
            return stage;
        }

        @Override
        public LinearAcceptor build() {
            Function<Request, Request> t;
            LinkedLinearAcceptor stage = new LinkedLinearAcceptor(this.transformations.poll());
            while ((t = this.transformations.poll()) != null) {
                stage = new LinkedLinearAcceptor(t, stage);
            }
            return stage;
        }
    }

    private static class LinkedTreeAcceptor
    implements TreeAcceptor {
        private final Function<Request, Request> transformation;
        private final List<TreeAcceptor> children;

        public LinkedTreeAcceptor(Function<Request, Request> transformation, List<TreeAcceptor> children) {
            this.transformation = transformation;
            this.children = children;
        }

        public LinkedTreeAcceptor(Function<Request, Request> transformation) {
            this.transformation = transformation;
            this.children = Collections.emptyList();
        }

        @Override
        public Pair<Request, Iterator<TreeAcceptor>> apply(Request data) {
            return Tuples.of(this.transformation.apply((Object)data), this.children.iterator());
        }
    }

    private static class TreeAcceptorBuilder
    implements TreeAcceptor.Builder {
        private final Function<Request, Request> transformation;
        private List<TreeAcceptor> children;

        public TreeAcceptorBuilder(Function<Request, Request> transformation) {
            this.transformation = transformation;
        }

        @Override
        public TreeAcceptor.Builder child(TreeAcceptor child) {
            if (this.children == null) {
                this.children = new LinkedList<TreeAcceptor>();
            }
            this.children.add(child);
            return this;
        }

        @Override
        public TreeAcceptor build() {
            return this.children == null ? new LinkedTreeAcceptor(this.transformation) : new LinkedTreeAcceptor(this.transformation, this.children);
        }
    }

    private static class InflectingLinearAcceptor
    implements LinearAcceptor,
    Inflecting<Request, Response> {
        private final Inflector<Request, Response> inflector;

        public InflectingLinearAcceptor(Inflector<Request, Response> inflector) {
            this.inflector = inflector;
        }

        @Override
        public Inflector<Request, Response> inflector() {
            return this.inflector;
        }

        @Override
        public Pair<Request, Optional<LinearAcceptor>> apply(Request request) {
            return Stages.terminalLinearContinuation(request);
        }
    }

    private static class InflectingTreeAcceptor
    implements TreeAcceptor,
    Inflecting<Request, Response> {
        private final Inflector<Request, Response> inflector;

        public InflectingTreeAcceptor(Inflector<Request, Response> inflector) {
            this.inflector = inflector;
        }

        @Override
        public Inflector<Request, Response> inflector() {
            return this.inflector;
        }

        @Override
        public Pair<Request, Iterator<TreeAcceptor>> apply(Request request) {
            return Stages.terminalTreeContinuation(request);
        }
    }
}

