/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Monitor;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.ComponentException;
import org.glassfish.hk2.DynamicBinderFactory;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Services;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestScope;
import org.jvnet.hk2.annotations.Inject;

class SuspendableInflectorAdapter
extends AbstractFuture<Response>
implements Inflector<Request, ListenableFuture<Response>>,
RequestInvoker.InvocationContext {
    private static final Logger LOGGER = Logger.getLogger(SuspendableInflectorAdapter.class.getName());
    private final BlockingDeque<RequestScope.Snapshot> requestScopeSnapshots = new LinkedBlockingDeque<RequestScope.Snapshot>();
    private RequestInvoker.InvocationContext.Status status = RequestInvoker.InvocationContext.Status.RUNNING;
    private final Monitor statusMonitor = new Monitor();
    private final Monitor.Guard statusRunningOrSuspended = new Monitor.Guard(this.statusMonitor){

        public boolean isSatisfied() {
            return SuspendableInflectorAdapter.this.status == RequestInvoker.InvocationContext.Status.RUNNING || SuspendableInflectorAdapter.this.status == RequestInvoker.InvocationContext.Status.SUSPENDED;
        }
    };
    private final Monitor.Guard statusRunning = new Monitor.Guard(this.statusMonitor){

        public boolean isSatisfied() {
            return SuspendableInflectorAdapter.this.status == RequestInvoker.InvocationContext.Status.RUNNING;
        }
    };
    private AtomicReference<Response> defaultResponse = new AtomicReference();
    private final Inflector<Request, Response> wrapped;
    private final Services services;

    public SuspendableInflectorAdapter(Inflector<Request, Response> wrapped, Services services) {
        this.wrapped = wrapped;
        this.services = services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<Response> apply(Request request) {
        block5: {
            try {
                DynamicBinderFactory dynamicBindings = this.services.bindDynamically();
                dynamicBindings.bind(RequestInvoker.InvocationContext.class, new Class[0]).toFactory((Factory)new Factory<RequestInvoker.InvocationContext>(){

                    public RequestInvoker.InvocationContext get() throws ComponentException {
                        return SuspendableInflectorAdapter.this;
                    }
                }).in(RequestScope.class);
                dynamicBindings.commit();
                Response response = this.wrapped.apply(request);
                if (!this.statusMonitor.enterIf(this.statusRunning)) break block5;
                try {
                    this.status = RequestInvoker.InvocationContext.Status.RESUMED;
                    this.set(response);
                }
                finally {
                    this.statusMonitor.leave();
                }
            }
            catch (Exception ex) {
                this.resume(ex);
            }
        }
        return this;
    }

    @Override
    public void pushRequestScope(RequestScope.Snapshot snapshot) {
        this.requestScopeSnapshots.push(snapshot);
    }

    @Override
    public RequestScope.Snapshot popRequestScope() {
        try {
            return this.requestScopeSnapshots.take();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestInvoker.InvocationContext.Status status() {
        this.statusMonitor.enter();
        try {
            RequestInvoker.InvocationContext.Status status = this.status;
            return status;
        }
        finally {
            this.statusMonitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(Response response) {
        if (this.statusMonitor.enterIf(this.statusRunningOrSuspended)) {
            try {
                this.status = RequestInvoker.InvocationContext.Status.RESUMED;
            }
            finally {
                this.statusMonitor.leave();
            }
        } else {
            throw new IllegalStateException(LocalizationMessages.ILLEGAL_INVOCATION_CONTEXT_STATE((Object)this.status, "resume"));
        }
        this.set(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(Throwable response) {
        if (this.statusMonitor.enterIf(this.statusRunningOrSuspended)) {
            try {
                this.status = RequestInvoker.InvocationContext.Status.RESUMED;
            }
            finally {
                this.statusMonitor.leave();
            }
        } else {
            throw new IllegalStateException(LocalizationMessages.ILLEGAL_INVOCATION_CONTEXT_STATE((Object)this.status, "resume"));
        }
        this.setException(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> suspend() {
        if (this.statusMonitor.enterIf(this.statusRunningOrSuspended)) {
            try {
                this.status = RequestInvoker.InvocationContext.Status.SUSPENDED;
            }
            finally {
                this.statusMonitor.leave();
            }
        } else {
            LOGGER.log(Level.FINE, "Failed to suspend request invocation context in state \"{0}\"", (Object)this.status);
        }
        return this;
    }

    @Override
    public Future<?> suspend(long millis) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<?> suspend(long time, TimeUnit unit) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long suspesionTimeout() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void interruptTask() {
    }

    @Override
    public void setResponse(Response response) {
        this.defaultResponse.set(response);
    }

    @Override
    public Response getResponse() {
        return this.defaultResponse.get();
    }

    public static class Builder {
        @Inject
        private Services services;

        public Builder() {
        }

        public Builder(Services requestScope) {
            this.services = requestScope;
        }

        public SuspendableInflectorAdapter build(Inflector<Request, Response> wrapped) {
            return new SuspendableInflectorAdapter(wrapped, this.services);
        }
    }
}

