/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util;

import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class ExtendedLogger
extends Logger {
    private final Logger logger;
    private final Level debugLevel;

    public ExtendedLogger(Logger logger, Level debugLevel) {
        super(logger.getName(), logger.getResourceBundleName());
        this.logger = logger;
        this.debugLevel = debugLevel;
    }

    public boolean isDebugLoggable() {
        return this.logger.isLoggable(this.debugLevel);
    }

    public Level getDebugLevel() {
        return this.debugLevel;
    }

    public void debugLog(String messageTemplate, Object ... args) {
        if (this.logger.isLoggable(this.debugLevel)) {
            Object[] messageArguments = args == null || args.length == 0 ? new Object[1] : Arrays.copyOf(args, args.length + 1);
            messageArguments[messageArguments.length - 1] = Thread.currentThread().getName();
            StringBuilder messageBuilder = new StringBuilder(messageTemplate.length() + 15);
            messageBuilder.append(messageTemplate).append(" on thread {").append(messageArguments.length - 1).append('}');
            this.logger.log(this.debugLevel, messageBuilder.toString(), messageArguments);
        }
    }

    public String toString() {
        return this.logger.toString();
    }

    public int hashCode() {
        return this.logger.hashCode();
    }

    public boolean equals(Object obj) {
        return this.logger.equals(obj);
    }

    @Override
    public void warning(String msg) {
        this.logger.warning(msg);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.logger.throwing(sourceClass, sourceMethod, thrown);
    }

    @Override
    public void severe(String msg) {
        this.logger.severe(msg);
    }

    @Override
    public void setUseParentHandlers(boolean useParentHandlers) {
        this.logger.setUseParentHandlers(useParentHandlers);
    }

    @Override
    public void setParent(Logger parent) {
        this.logger.setParent(parent);
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        this.logger.setLevel(newLevel);
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        this.logger.setFilter(newFilter);
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        this.logger.removeHandler(handler);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        this.logger.logrb(level, sourceClass, sourceMethod, bundleName, msg, thrown);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        this.logger.logrb(level, sourceClass, sourceMethod, bundleName, msg, params);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        this.logger.logrb(level, sourceClass, sourceMethod, bundleName, msg, param1);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        this.logger.logrb(level, sourceClass, sourceMethod, bundleName, msg);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.logger.logp(level, sourceClass, sourceMethod, msg, thrown);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.logger.logp(level, sourceClass, sourceMethod, msg, params);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.logger.logp(level, sourceClass, sourceMethod, msg, param1);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.logger.logp(level, sourceClass, sourceMethod, msg);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        this.logger.log(level, msg, thrown);
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        this.logger.log(level, msg, params);
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        this.logger.log(level, msg, param1);
    }

    @Override
    public void log(Level level, String msg) {
        this.logger.log(level, msg);
    }

    @Override
    public void log(LogRecord record) {
        this.logger.log(record);
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    @Override
    public void info(String msg) {
        this.logger.info(msg);
    }

    @Override
    public boolean getUseParentHandlers() {
        return this.logger.getUseParentHandlers();
    }

    @Override
    public String getResourceBundleName() {
        return this.logger.getResourceBundleName();
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.logger.getResourceBundle();
    }

    @Override
    public Logger getParent() {
        return this.logger.getParent();
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public Level getLevel() {
        return this.logger.getLevel();
    }

    @Override
    public Handler[] getHandlers() {
        return this.logger.getHandlers();
    }

    @Override
    public Filter getFilter() {
        return this.logger.getFilter();
    }

    @Override
    public void finest(String msg) {
        this.logger.finest(msg);
    }

    @Override
    public void finer(String msg) {
        this.logger.finer(msg);
    }

    @Override
    public void fine(String msg) {
        this.logger.fine(msg);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.logger.exiting(sourceClass, sourceMethod, result);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        this.logger.exiting(sourceClass, sourceMethod);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        this.logger.entering(sourceClass, sourceMethod, params);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this.logger.entering(sourceClass, sourceMethod, param1);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        this.logger.entering(sourceClass, sourceMethod);
    }

    @Override
    public void config(String msg) {
        this.logger.config(msg);
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        this.logger.addHandler(handler);
    }
}

