/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MessageProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.ResponseHeaders;
import org.glassfish.jersey.internal.util.collection.ListMultimapAdapter;
import org.glassfish.jersey.message.internal.Response;

final class JaxrsResponseView
extends javax.ws.rs.core.Response {
    private final Response wrapped;

    public JaxrsResponseView(Response wrapped) {
        this.wrapped = wrapped;
    }

    static Response unwrap(javax.ws.rs.core.Response response) {
        if (response instanceof JaxrsResponseView) {
            return ((JaxrsResponseView)response).wrapped;
        }
        throw new IllegalArgumentException(String.format("Response class type '%s' not supported.", response.getClass().getName()));
    }

    public Map<String, Object> getProperties() {
        return this.wrapped.properties();
    }

    public int getStatus() {
        return this.wrapped.status().getStatusCode();
    }

    public Response.Status getStatusEnum() {
        return Response.Status.fromStatusCode((int)this.wrapped.status().getStatusCode());
    }

    public ResponseHeaders getHeaders() {
        return this.wrapped.getJaxrsHeaders();
    }

    public Object getEntity() {
        return this.wrapped.content();
    }

    public <T> T readEntity(Class<T> type) throws MessageProcessingException {
        return this.wrapped.content(type);
    }

    public <T> T readEntity(GenericType<T> entityType) throws MessageProcessingException {
        return this.wrapped.content(entityType);
    }

    public <T> T readEntity(Class<T> type, Annotation[] annotations) throws MessageProcessingException {
        return this.wrapped.content(type, annotations);
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) throws MessageProcessingException {
        return this.wrapped.content(entityType, annotations);
    }

    public boolean hasEntity() {
        return !this.wrapped.isEmpty();
    }

    public boolean isEntityRetrievable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void bufferEntity() throws MessageProcessingException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() throws MessageProcessingException {
        this.wrapped.close();
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return new ListMultimapAdapter<String, Object>(this.wrapped.headers());
    }
}

