/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Optional;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.JerseyFilterContext;
import org.glassfish.jersey.process.internal.LinearAcceptor;
import org.glassfish.jersey.process.internal.RequestFilterAcceptor;
import org.glassfish.jersey.process.internal.ResponseFilterResponder;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.jvnet.hk2.annotations.Inject;

public class FilteringInflector
implements Inflector<Request, Response> {
    private final Inflector<Request, Response> wrapped;
    private final RequestFilterAcceptor requestFilterAcceptor;
    private final ResponseFilterResponder responseFilterResponder;
    private final Factory<JerseyFilterContext> filterContextFactory;
    private final Factory<ResponseProcessor.RespondingContext> respondingContextFactory;

    private FilteringInflector(Inflector<Request, Response> wrapped, RequestFilterAcceptor requestFilterAcceptor, ResponseFilterResponder responseFilterResponder, Factory<JerseyFilterContext> filterContextFactory, Factory<ResponseProcessor.RespondingContext> respondingContextFactory) {
        this.wrapped = wrapped;
        this.requestFilterAcceptor = requestFilterAcceptor;
        this.responseFilterResponder = responseFilterResponder;
        this.filterContextFactory = filterContextFactory;
        this.respondingContextFactory = respondingContextFactory;
    }

    @Override
    public Response apply(Request request) {
        JerseyFilterContext filterContext = (JerseyFilterContext)this.filterContextFactory.get();
        ((ResponseProcessor.RespondingContext)this.respondingContextFactory.get()).push(this.responseFilterResponder);
        filterContext.setResponse(null);
        Pair<Request, Optional<LinearAcceptor>> pair = this.requestFilterAcceptor.apply(request);
        Response response = filterContext.getResponse();
        return response != null ? response : this.wrapped.apply(pair.left());
    }

    public static class Builder {
        @Inject
        private RequestFilterAcceptor requestFilterAcceptor;
        @Inject
        private ResponseFilterResponder responseFilterResponder;
        @Inject
        private Factory<JerseyFilterContext> filterContextFactory;
        @Inject
        private Factory<ResponseProcessor.RespondingContext> respondingContextFactory;

        public FilteringInflector build(Inflector<Request, Response> wrapped) {
            return new FilteringInflector(wrapped, this.requestFilterAcceptor, this.responseFilterResponder, this.filterContextFactory, this.respondingContextFactory);
        }
    }
}

