/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.LinearAcceptor;
import org.glassfish.jersey.process.internal.RequestProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.process.internal.StagingContext;
import org.jvnet.hk2.annotations.Inject;

public class LinearRequestProcessor
implements RequestProcessor {
    private final LinearAcceptor rootAcceptor;
    private final Factory<StagingContext<Request>> contextProvider;

    public LinearRequestProcessor(@Inject @Stage.Root LinearAcceptor rootAcceptor, @Inject Factory<StagingContext<Request>> contextProvider) {
        this.rootAcceptor = rootAcceptor;
        this.contextProvider = contextProvider;
    }

    @Override
    public Pair<Request, Optional<Inflector<Request, Response>>> apply(Request request) {
        StagingContext context = (StagingContext)this.contextProvider.get();
        LinearAcceptor stage = this.rootAcceptor;
        Pair<Request, Optional> continuation = Tuples.of(request, Optional.fromNullable((Object)stage));
        while (continuation.right().isPresent()) {
            stage = (LinearAcceptor)continuation.right().get();
            context.beforeStage(stage, continuation.left());
            continuation = stage.apply(continuation.left());
            context.afterStage(stage, continuation.left());
        }
        Request processed = continuation.left();
        Optional lastStage = ((StagingContext)this.contextProvider.get()).lastStage();
        Preconditions.checkState((boolean)lastStage.isPresent(), (Object)"No stage has been invoked as part of the processing.");
        return Tuples.of(processed, Stages.extractInflector((Stage)lastStage.get()));
    }
}

