/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util.collection;

import com.google.common.base.Function;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;

public class ListMultimapAdapter<K, V>
implements MultivaluedMap<K, V> {
    private final ListMultimap<K, V> multimap;
    private transient Map<K, List<V>> mapView;

    public ListMultimapAdapter(ListMultimap<K, V> multimap) {
        this.multimap = multimap;
    }

    public void putSingle(K key, V value) {
        this.multimap.replaceValues(key, Collections.singleton(value));
    }

    public void add(K key, V value) {
        this.multimap.put(key, value);
    }

    public V getFirst(K key) {
        Iterator values = this.multimap.get(key).iterator();
        if (values.hasNext()) {
            return (V)values.next();
        }
        return null;
    }

    public int size() {
        return this.multimap.size();
    }

    public boolean isEmpty() {
        return this.multimap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.multimap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.multimap.containsValue(value);
    }

    public List<V> get(Object key) {
        if (this.multimap.containsKey(key)) {
            return this.multimap.get(key);
        }
        return null;
    }

    public List<V> put(K key, List<V> values) {
        List oldValues = null;
        if (this.multimap.containsKey(key)) {
            oldValues = this.multimap.removeAll(key);
        }
        this.multimap.putAll(key, values);
        return oldValues;
    }

    public List<V> remove(Object key) {
        if (this.multimap.containsKey(key)) {
            return this.multimap.removeAll(key);
        }
        return null;
    }

    public void putAll(Map<? extends K, ? extends List<V>> map) {
        for (Map.Entry<K, List<V>> e : map.entrySet()) {
            this.multimap.putAll(e.getKey(), (Iterable)e.getValue());
        }
    }

    public void clear() {
        this.multimap.clear();
    }

    public Set<K> keySet() {
        return this.multimap.keySet();
    }

    public Collection<List<V>> values() {
        return this.mapView().values();
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.mapView().entrySet();
    }

    private Map<K, List<V>> mapView() {
        Map result = this.mapView;
        return result == null ? (this.mapView = Maps.transformValues((Map)this.multimap.asMap(), (Function)new Function<Collection<V>, List<V>>(){

            public List<V> apply(Collection<V> input) {
                return (List)input;
            }
        })) : result;
    }
}

