/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.glassfish.jersey.internal.util.collection.ListMultimapAdapter;
import org.glassfish.jersey.message.internal.Headers;
import org.glassfish.jersey.message.internal.HeadersFactory;

class MutableHeaders
implements Headers,
Headers.Builder<MutableHeaders> {
    private final ListMultimap<String, String> stringHeaders = HeadersFactory.createInbound();
    private transient ListMultimap<String, String> immutableHeadersView;
    private final ListMultimap<String, Object> objectHeaders = HeadersFactory.createOutbound();

    public MutableHeaders() {
    }

    public MutableHeaders(MutableHeaders that) {
        this();
        this.stringHeaders.putAll(that.stringHeaders);
        this.objectHeaders.putAll(that.objectHeaders);
    }

    @Override
    public String header(String name) {
        Iterator<String> values = this.headerValues(name).iterator();
        if (!values.hasNext()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(values.next());
        while (values.hasNext()) {
            buffer.append(',').append(values.next());
        }
        return buffer.toString();
    }

    @Override
    public ListMultimap<String, String> headers() {
        this.fetchAll();
        if (this.immutableHeadersView == null) {
            this.immutableHeadersView = Multimaps.unmodifiableListMultimap(this.stringHeaders);
        }
        return this.immutableHeadersView;
    }

    @Override
    public List<String> headerValues(String name) {
        this.fetch(name);
        if (this.immutableHeadersView == null) {
            this.immutableHeadersView = Multimaps.unmodifiableListMultimap(this.stringHeaders);
        }
        return this.immutableHeadersView.get((Object)name);
    }

    @Override
    public MultivaluedMap<String, String> toJaxrsHeaderMap() {
        return new ListMultimapAdapter<String, String>(this.headers());
    }

    @Override
    public MutableHeaders header(String name, Object value) {
        this.objectHeaders.put((Object)name, value);
        return this;
    }

    @Override
    public MutableHeaders header(String name, String value) {
        this.stringHeaders.put((Object)name, (Object)value);
        return this;
    }

    @Override
    public MutableHeaders headers(String name, Object ... values) {
        this.objectHeaders.putAll((Object)name, Arrays.asList(values));
        return this;
    }

    @Override
    public MutableHeaders headers(String name, String ... values) {
        this.stringHeaders.putAll((Object)name, Arrays.asList(values));
        return this;
    }

    @Override
    public MutableHeaders headers(String name, Iterable<? extends Object> values) {
        this.objectHeaders.putAll((Object)name, values);
        return this;
    }

    @Override
    public MutableHeaders headers(Multimap<String, ? extends Object> headers) {
        this.objectHeaders.putAll(headers);
        return this;
    }

    @Override
    public MutableHeaders headers(Map<String, List<String>> headers) {
        this.objectHeaders.putAll(HeadersFactory.createInbound(headers));
        return this;
    }

    @Override
    public MutableHeaders remove(String name) {
        this.objectHeaders.removeAll((Object)name);
        this.stringHeaders.removeAll((Object)name);
        return this;
    }

    @Override
    public MutableHeaders replace(String name, Iterable<? extends Object> values) {
        this.stringHeaders.removeAll((Object)name);
        this.objectHeaders.replaceValues((Object)name, values);
        return this;
    }

    @Override
    public MutableHeaders replaceAll(ListMultimap<String, String> headers) {
        this.objectHeaders.clear();
        this.stringHeaders.clear();
        this.stringHeaders.putAll(headers);
        return this;
    }

    private void fetch(String headerName) {
        if (this.objectHeaders.isEmpty()) {
            return;
        }
        List values = this.objectHeaders.removeAll((Object)headerName);
        if (values.isEmpty()) {
            return;
        }
        this.stringHeaders.putAll((Object)headerName, HeadersFactory.toString(values, RuntimeDelegate.getInstance()));
    }

    private void fetchAll() {
        if (!this.objectHeaders.isEmpty()) {
            this.stringHeaders.putAll(HeadersFactory.toString(this.objectHeaders, RuntimeDelegate.getInstance()));
            this.objectHeaders.clear();
        }
    }
}

