/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.client.Configuration;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Services;
import org.glassfish.jersey.internal.ServiceProviders;
import org.glassfish.jersey.process.internal.JerseyFilterContext;
import org.jvnet.hk2.annotations.Inject;

abstract class AbstractFilterProcessor<T> {
    protected static final int FILTER_ORDER_ASCENDING = 1;
    protected static final int FILTER_ORDER_DESCENDING = -1;
    @Inject
    private Services services;
    @Inject
    protected Factory<JerseyFilterContext> filterContextFactory;
    private final int ordering;

    protected AbstractFilterProcessor() {
        this.ordering = 1;
    }

    protected AbstractFilterProcessor(int ordering) {
        this.ordering = ordering;
    }

    protected final List<T> getFilters(Class<T> filterContract) {
        ServiceProviders serviceProviders = (ServiceProviders)this.services.forContract(ServiceProviders.class).get();
        return serviceProviders.getAll(filterContract, new Comparator<T>(){

            @Override
            public int compare(T t, T t1) {
                return (this.getPriority(t) - this.getPriority(t1)) * AbstractFilterProcessor.this.ordering;
            }

            private int getPriority(T t) {
                if (t.getClass().isAnnotationPresent(BindingPriority.class)) {
                    return t.getClass().getAnnotation(BindingPriority.class).value();
                }
                return 500;
            }
        });
    }

    protected final Map<String, Object> getProperties() {
        Configuration config = (Configuration)this.services.forContract(Configuration.class).get();
        return config != null ? config.getProperties() : null;
    }
}

