/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Optional;
import java.util.Map;
import javax.ws.rs.core.Request;
import javax.ws.rs.ext.FilterContext;
import javax.ws.rs.ext.RequestFilter;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.internal.AbstractFilterProcessor;
import org.glassfish.jersey.process.internal.JerseyFilterContext;
import org.glassfish.jersey.process.internal.LinearAcceptor;

public class RequestFilterAcceptor
extends AbstractFilterProcessor<RequestFilter>
implements LinearAcceptor {
    @Override
    public Pair<Request, Optional<LinearAcceptor>> apply(Request data) {
        JerseyFilterContext filterContext = (JerseyFilterContext)this.filterContextFactory.get();
        filterContext.setRequest(data);
        Map<String, Object> properties = this.getProperties();
        if (properties != null) {
            filterContext.setProperties(properties);
        }
        assert (filterContext.getResponse() == null);
        for (RequestFilter filter : this.getFilters(RequestFilter.class)) {
            try {
                filter.preFilter((FilterContext)filterContext);
                if (filterContext.getResponse() == null) continue;
                break;
            }
            catch (Exception e) {
                throw new MappableException(e);
            }
        }
        return Tuples.of(filterContext.getRequest(), Optional.absent());
    }
}

