/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.ResponseHeaders;
import org.glassfish.jersey.message.internal.Headers;
import org.glassfish.jersey.message.internal.HttpHelper;

class JaxrsResponseHeadersView
implements ResponseHeaders {
    private Headers wrapped;

    public JaxrsResponseHeadersView(Headers wrapped) {
        this.wrapped = wrapped;
    }

    public Map<String, NewCookie> getCookies() {
        return HttpHelper.getNewCookies(this.wrapped);
    }

    public EntityTag getEntityTag() {
        return HttpHelper.getEntityTag(this.wrapped);
    }

    public Date getLastModified() {
        return HttpHelper.getLastModified(this.wrapped);
    }

    public URI getLocation() {
        return HttpHelper.getLocation(this.wrapped);
    }

    public Set<String> getAllowedMethods() {
        return HttpHelper.getAllowedMethods(this.wrapped);
    }

    public Date getDate() {
        return HttpHelper.getDate(this.wrapped);
    }

    public String getHeader(String name) {
        return this.wrapped.header(name);
    }

    public MultivaluedMap<String, String> asMap() {
        return this.wrapped.headers();
    }

    public List<String> getHeaderValues(String name) {
        return this.wrapped.headerValues(name);
    }

    public Locale getLanguage() {
        return HttpHelper.getContentLanguageAsLocale(this.wrapped);
    }

    public int getLength() {
        return HttpHelper.getContentLength(this.wrapped);
    }

    public MediaType getMediaType() {
        return HttpHelper.getContentType(this.wrapped);
    }

    public Set<Link> getLinks() {
        return HttpHelper.getLinks(this.wrapped);
    }

    public Link getLink(String relation) {
        for (Link l : HttpHelper.getLinks(this.wrapped)) {
            List rels = l.getRel();
            if (rels == null || !rels.contains(relation)) continue;
            return l;
        }
        return null;
    }

    public boolean hasLink(String relation) {
        for (Link l : HttpHelper.getLinks(this.wrapped)) {
            List rels = l.getRel();
            if (rels == null || !rels.contains(relation)) continue;
            return true;
        }
        return false;
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLink(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink((Link)link);
    }
}

