/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.AbstractFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Responder;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.jvnet.hk2.annotations.Inject;

public final class ResponseProcessor
extends AbstractFuture<Response>
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ResponseProcessor.class.getName());
    private final RequestScope requestScope;
    private volatile RequestScope.Instance scopeInstance;
    private final InvocationCallback callback;
    private final Factory<InvocationContext> invocationCtxProvider;
    private final Factory<RespondingContext> respondingCtxProvider;
    private final Factory<ExceptionMappers> exceptionMappersProvider;

    private ResponseProcessor(RequestScope requestScope, RequestScope.Instance scopeInstance, InvocationCallback callback, Factory<InvocationContext> invocationCtxProvider, Factory<RespondingContext> respondingCtxProvider, Factory<ExceptionMappers> exceptionMappersProvider) {
        this.requestScope = requestScope;
        this.scopeInstance = scopeInstance;
        this.callback = callback;
        this.invocationCtxProvider = invocationCtxProvider;
        this.respondingCtxProvider = respondingCtxProvider;
        this.exceptionMappersProvider = exceptionMappersProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.requestScope.runInScope(this.scopeInstance, new Runnable(){

                @Override
                public void run() {
                    Response response;
                    block11: {
                        Future<Response> inflectedResponse = ((InvocationContext)ResponseProcessor.this.invocationCtxProvider.get()).getInflectedResponse();
                        if (inflectedResponse.isCancelled()) {
                            ResponseProcessor.super.cancel(true);
                            return;
                        }
                        try {
                            response = inflectedResponse.get();
                        }
                        catch (Exception ex) {
                            Throwable unwrapped = ex instanceof ExecutionException ? ex.getCause() : ex;
                            LOGGER.log(Level.FINE, "Request-to-response transformation finished with an exception.", unwrapped);
                            try {
                                response = ResponseProcessor.this.mapException(unwrapped);
                            }
                            catch (Exception ex2) {
                                ResponseProcessor.this.setResult(ex2);
                                return;
                            }
                            if (response != null) break block11;
                            ResponseProcessor.this.setResult(unwrapped);
                            return;
                        }
                    }
                    for (int i = 0; i < 2; ++i) {
                        try {
                            response = ResponseProcessor.this.runResponders(response);
                            break;
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINE, "Responder chain execution finished with an exception.", ex);
                            if (i == 0) {
                                try {
                                    response = ResponseProcessor.this.mapException(ex);
                                }
                                catch (Exception ex2) {
                                    ResponseProcessor.this.setResult(ex2);
                                    return;
                                }
                            }
                            if (response != null) continue;
                            ResponseProcessor.this.setResult(ex);
                            return;
                        }
                    }
                    ResponseProcessor.this.setResult(response);
                }
            });
        }
        finally {
            this.scopeInstance.release();
        }
    }

    private Response runResponders(Response response) {
        Optional<Responder> responder = ((RespondingContext)this.respondingCtxProvider.get()).createStageChain();
        if (responder.isPresent()) {
            Pair<Response, Optional<Responder>> continuation = Tuples.of(response, responder);
            while (continuation.right().isPresent()) {
                Responder next = (Responder)continuation.right().get();
                continuation = next.apply(continuation.left());
            }
            return continuation.left();
        }
        return response;
    }

    private Response mapException(Throwable exception) throws Exception {
        ExceptionMapper<?> mapper;
        Response response = null;
        if (exception instanceof MappableException) {
            exception = exception.getCause();
        }
        if (exception instanceof WebApplicationException) {
            response = ((WebApplicationException)exception).getResponse();
        }
        ExceptionMappers exceptionMappers = (ExceptionMappers)this.exceptionMappersProvider.get();
        if (!(response != null && response.hasEntity() || exceptionMappers == null || (mapper = exceptionMappers.find(exception.getClass())) == null)) {
            response = mapper.toResponse(exception);
        }
        return response;
    }

    private void setResult(Response response) {
        super.set((Object)response);
        this.notifyCallback(response);
    }

    private void setResult(Throwable exception) {
        super.setException(exception);
        this.notifyCallback(exception);
    }

    private void notifyCallback(Response response) {
        try {
            this.callback.result(response);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, LocalizationMessages.CALLBACK_METHOD_INVOCATION_FAILED("result"), ex);
        }
    }

    private void notifyCallback(Throwable exception) {
        try {
            this.callback.failure(exception);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, LocalizationMessages.CALLBACK_METHOD_INVOCATION_FAILED("failure"), ex);
        }
    }

    public static class Builder {
        @Inject
        private RequestScope requestScope;
        @Inject
        private Factory<InvocationContext> invocationCtxProvider;
        @Inject
        private Factory<RespondingContext> respondingCtxProvider;
        @Inject
        private Factory<ExceptionMappers> exceptionMappersProvider;

        public ResponseProcessor build(InvocationCallback callback, RequestScope.Instance scopeInstance) {
            return new ResponseProcessor(this.requestScope, scopeInstance, callback, this.invocationCtxProvider, this.respondingCtxProvider, this.exceptionMappersProvider);
        }
    }

    public static interface RespondingContext {
        public void push(Function<Response, Response> var1);

        public Optional<Responder> createStageChain();
    }
}

