/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.ExceptionWrapperInterceptor;
import org.glassfish.jersey.message.internal.InterceptorExecutor;
import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;
import org.glassfish.jersey.process.internal.PriorityComparator;

public class WriterInterceptorExecutor
extends InterceptorExecutor
implements WriterInterceptorContext {
    private Iterator<WriterInterceptor> iterator;
    private OutputStream outputStream;
    private final MultivaluedMap<String, Object> headers;
    private Object entity;

    public WriterInterceptorExecutor(Object entity, GenericType genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, Map<String, Object> properties, OutputStream entityStream, MessageBodyWorkers workers, MessageBodyWorkers.MessageBodySizeCallback sizeCallback, boolean intercept, boolean writeEntity) {
        super(genericType, annotations, mediaType, properties);
        this.entity = entity;
        this.headers = headers;
        this.outputStream = entityStream;
        ArrayList<WriterInterceptor> interceptors = new ArrayList<WriterInterceptor>();
        for (WriterInterceptor interceptor : workers.getWriterInterceptors()) {
            if (!intercept && !(interceptor instanceof ExceptionWrapperInterceptor)) continue;
            interceptors.add(interceptor);
        }
        Collections.sort(interceptors, new PriorityComparator(PriorityComparator.Order.ASCENDING));
        interceptors.add(new TerminalWriterInterceptor(workers, sizeCallback, writeEntity));
        this.iterator = interceptors.iterator();
    }

    public WriterInterceptor getNextInterceptor() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        return this.iterator.next();
    }

    public void proceed() throws IOException {
        WriterInterceptor nextInterceptor = this.getNextInterceptor();
        if (nextInterceptor == null) {
            throw new ProcessingException(LocalizationMessages.ERROR_INTERCEPTOR_WRITER_PROCEED());
        }
        nextInterceptor.aroundWriteTo((WriterInterceptorContext)this);
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }

    private static class TerminalWriterInterceptor
    implements WriterInterceptor {
        private final MessageBodyWorkers workers;
        private final MessageBodyWorkers.MessageBodySizeCallback sizeCallback;
        private final boolean writeEntity;

        public TerminalWriterInterceptor(MessageBodyWorkers workers, MessageBodyWorkers.MessageBodySizeCallback sizeCallback, boolean writeEntity) {
            this.workers = workers;
            this.sizeCallback = sizeCallback;
            this.writeEntity = writeEntity;
        }

        public void aroundWriteTo(WriterInterceptorContext context) throws WebApplicationException, IOException {
            MessageBodyWriter writer = this.workers.getMessageBodyWriter(context.getType(), context.getGenericType(), context.getAnnotations(), context.getMediaType());
            if (writer == null) {
                throw new MessageBodyProviderNotFoundException(LocalizationMessages.ERROR_NOTFOUND_MESSAGEBODYWRITER(context.getMediaType(), context.getType(), context.getGenericType()));
            }
            if (this.sizeCallback != null) {
                long size = writer.getSize(context.getEntity(), context.getType(), context.getGenericType(), context.getAnnotations(), context.getMediaType());
                this.sizeCallback.onRequestEntitySize(size);
            }
            if (this.writeEntity) {
                writer.writeTo(context.getEntity(), context.getType(), context.getGenericType(), context.getAnnotations(), context.getMediaType(), context.getHeaders(), context.getOutputStream());
            }
        }
    }
}

