/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Function;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.message.internal.Responses;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.jvnet.hk2.annotations.Inject;

public class MessageBodyWorkersInitializer
implements Function<Request, Request> {
    private final Factory<MessageBodyWorkers> workersFactory;
    private final Factory<ResponseProcessor.RespondingContext<Response>> respondingContextFactory;

    public MessageBodyWorkersInitializer(@Inject Factory<MessageBodyWorkers> workersFactory, @Inject Factory<ResponseProcessor.RespondingContext<Response>> respondingContextFactory) {
        this.workersFactory = workersFactory;
        this.respondingContextFactory = respondingContextFactory;
    }

    public Request apply(Request request) {
        Request.RequestBuilder requestBuilder = Requests.toBuilder(request);
        final MessageBodyWorkers workers = (MessageBodyWorkers)this.workersFactory.get();
        Requests.setMessageWorkers(requestBuilder, workers);
        ((ResponseProcessor.RespondingContext)this.respondingContextFactory.get()).push(new Function<Response, Response>(){

            public Response apply(Response response) {
                if (response != null) {
                    Response.ResponseBuilder responseBuilder = Responses.toBuilder(response);
                    Responses.setMessageWorkers(responseBuilder, workers);
                    return responseBuilder.build();
                }
                return null;
            }
        });
        return requestBuilder.build();
    }
}

