/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AsyncInflectorAdapter;
import org.glassfish.jersey.process.internal.InflectorNotFoundException;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.ProcessingExecutorsFactory;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.jvnet.hk2.annotations.Inject;

public class RequestInvoker<REQUEST, RESPONSE> {
    private static final InvocationCallback EMPTY_CALLBACK = new InvocationCallback(){

        public void result(Object response) {
        }

        @Override
        public void failure(Throwable exception) {
        }

        @Override
        public void suspended(long time, TimeUnit unit, InvocationContext context) {
        }

        @Override
        public void suspendTimeoutChanged(long time, TimeUnit unit) {
        }

        @Override
        public void resumed() {
        }

        @Override
        public void cancelled() {
        }
    };
    private final Stage<REQUEST> rootStage;
    private final RequestScope requestScope;
    private final AsyncInflectorAdapter.Builder<REQUEST, RESPONSE> asyncAdapterBuilder;
    private final ResponseProcessor.Builder<RESPONSE> responseProcessorBuilder;
    private final Factory<Ref<InvocationContext>> invocationContextReferenceFactory;
    private final ProcessingExecutorsFactory executorsFactory;

    private RequestInvoker(Stage<REQUEST> rootStage, RequestScope requestScope, AsyncInflectorAdapter.Builder<REQUEST, RESPONSE> asyncAdapterBuilder, ResponseProcessor.Builder<RESPONSE> responseProcessorBuilder, Factory<Ref<InvocationContext>> invocationContextReferenceFactory, ProcessingExecutorsFactory executorsFactory) {
        this.requestScope = requestScope;
        this.rootStage = rootStage;
        this.asyncAdapterBuilder = asyncAdapterBuilder;
        this.responseProcessorBuilder = responseProcessorBuilder;
        this.invocationContextReferenceFactory = invocationContextReferenceFactory;
        this.executorsFactory = executorsFactory;
    }

    public ListenableFuture<RESPONSE> apply(REQUEST request) {
        return this.apply(request, EMPTY_CALLBACK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<RESPONSE> apply(final REQUEST request, InvocationCallback<RESPONSE> callback) {
        final RequestScope.Instance instance = this.requestScope.suspendCurrent();
        final AsyncInflectorAdapter<REQUEST, RESPONSE> asyncInflector = this.asyncAdapterBuilder.create(new AcceptingInvoker(), callback);
        final ResponseProcessor<RESPONSE> responseProcessor = this.responseProcessorBuilder.build((Future<RESPONSE>)((Object)asyncInflector), callback, instance);
        final Runnable requester = new Runnable(){

            @Override
            public void run() {
                ((Ref)RequestInvoker.this.invocationContextReferenceFactory.get()).set(asyncInflector);
                ListenableFuture response = asyncInflector.apply(request);
                response.addListener((Runnable)responseProcessor, (Executor)RequestInvoker.this.executorsFactory.getRespondingExecutor());
            }
        };
        try {
            try {
                this.executorsFactory.getRequestingExecutor().submit(new Runnable(){

                    @Override
                    public void run() {
                        RequestInvoker.this.requestScope.runInScope(instance, requester);
                    }
                });
                return responseProcessor;
            }
            catch (RejectedExecutionException ex) {
                throw new ProcessingException(LocalizationMessages.REQUEST_EXECUTION_FAILED(), ex);
            }
        }
        catch (ProcessingException ex) {
            try {
                SettableFuture failedResponse = SettableFuture.create();
                failedResponse.setException((Throwable)ex);
                SettableFuture settableFuture = failedResponse;
                return settableFuture;
            }
            finally {
                callback.failure(ex);
            }
        }
    }

    private class AcceptingInvoker
    implements Inflector<REQUEST, RESPONSE> {
        private AcceptingInvoker() {
        }

        @Override
        public RESPONSE apply(REQUEST request) {
            Stage currentStage;
            Stage lastStage = null;
            Stage.Continuation continuation = Stage.Continuation.of(request, RequestInvoker.this.rootStage);
            while ((currentStage = continuation.next()) != null) {
                lastStage = currentStage;
                continuation = currentStage.apply(continuation.result());
            }
            Inflector inflector = Stages.extractInflector(lastStage);
            Object result = continuation.result();
            Preconditions.checkState((lastStage != null ? 1 : 0) != 0, (Object)"No stage has been invoked as part of the processing.");
            if (inflector == null) {
                throw new InflectorNotFoundException("Terminal stage did not provide an inflector");
            }
            return inflector.apply(result);
        }
    }

    public static final class Builder {
        @Inject
        private RequestScope requestScope;
        @Inject
        private ResponseProcessor.Builder<Response> responseProcessorBuilder;
        @Inject
        private Factory<Ref<InvocationContext>> invocationContextReferenceFactory;
        @Inject
        private ProcessingExecutorsFactory executorsFactory;

        public RequestInvoker<Request, Response> build(Stage<Request> rootStage) {
            AsyncInflectorAdapter.Builder<Request, Response> asyncAdapterBuilder = new AsyncInflectorAdapter.Builder<Request, Response>(){

                @Override
                public AsyncInflectorAdapter<Request, Response> create(Inflector<Request, Response> wrapped, InvocationCallback<Response> callback) {
                    return new AsyncInflectorAdapter<Request, Response>(wrapped, callback){

                        @Override
                        protected Response convertResponse(Response response) {
                            return response;
                        }
                    };
                }
            };
            return new RequestInvoker<Request, Response>(rootStage, this.requestScope, asyncAdapterBuilder, this.responseProcessorBuilder, this.invocationContextReferenceFactory, this.executorsFactory);
        }
    }
}

