/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.Services;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.jvnet.hk2.annotations.Inject;

public class ServiceProviders {
    private static final Logger LOGGER = Logger.getLogger(ServiceProviders.class.getName());
    private final Services services;
    private final Set<Class<?>> providerClasses;
    private final Set<Object> providerInstances;

    private ServiceProviders(Services services, Set<Class<?>> classes, Set<Object> instances) {
        this.services = services;
        this.providerClasses = Collections.unmodifiableSet(Sets.newHashSet(classes == null ? Collections.emptySet() : classes));
        this.providerInstances = Collections.unmodifiableSet(Sets.newHashSet(instances == null ? Collections.emptySet() : instances));
    }

    public <T> Set<T> getCustom(Class<T> providerContract) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(this.getCustomInstances(providerContract));
        for (Class<?> pc : this.providerClasses) {
            Object o;
            if (!providerContract.isAssignableFrom(pc) || (o = this.getComponent(pc)) == null) continue;
            result.add(providerContract.cast(o));
        }
        return result;
    }

    public <T> List<T> getCustom(Class<T> providerContract, Comparator<T> comparator) {
        ArrayList providers = Lists.newArrayList(this.getDefault(providerContract));
        Collections.sort(providers, comparator);
        return providers;
    }

    public <T> Set<T> getDefault(Class<T> providerContract) {
        return Providers.getProviders(this.services, providerContract);
    }

    public <T> List<T> getDefault(Class<T> providerContract, Comparator<T> comparator) {
        ArrayList providers = Lists.newArrayList(this.getDefault(providerContract));
        Collections.sort(providers, comparator);
        return providers;
    }

    public <T> Set<T> getAll(Class<T> providerContract) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(this.getCustom(providerContract));
        result.addAll(this.getDefault(providerContract));
        return result;
    }

    public <T> List<T> getAll(Class<T> providerContract, Comparator<T> comparator) {
        ArrayList providers = Lists.newArrayList(this.getAll(providerContract));
        Collections.sort(providers, comparator);
        return providers;
    }

    public <T> void getCustom(Class<T> providerContract, ServiceListener<T> listener) {
        for (T t : this.getCustom(providerContract)) {
            listener.onAdd(t);
        }
    }

    public <T> void getAll(Class<T> providerContract, ServiceListener<T> listener) {
        for (T t : this.getCustom(providerContract)) {
            listener.onAdd(t);
        }
        for (T t : this.getDefault(providerContract)) {
            listener.onAdd(t);
        }
    }

    public <T> List<T> instantiate(Class<T> providerContract, String[] classNames) {
        LinkedList<T> ps = new LinkedList<T>();
        for (String className : classNames) {
            try {
                Class c = ReflectionHelper.classForNameWithException(className);
                if (providerContract.isAssignableFrom(c)) {
                    Object o = this.getComponent(c);
                    if (o == null) continue;
                    ps.add(providerContract.cast(o));
                    continue;
                }
                LOGGER.log(Level.SEVERE, "The class {0} is not assignable to the class {1}. This class is ignored.", new Object[]{className, providerContract.getName()});
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.SEVERE, "The class {0} could not be found. This class is ignored.", className);
            }
        }
        return ps;
    }

    public <T> List<T> instantiate(Class<T> providerContract, Class<? extends T>[] classes) {
        LinkedList<T> ps = new LinkedList<T>();
        for (Class<? extends T> c : classes) {
            Object o = this.getComponent(c);
            if (o == null) continue;
            ps.add(providerContract.cast(o));
        }
        return ps;
    }

    private Object getComponent(Class<?> provider) {
        try {
            return this.services.byType(provider).get();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Component instantiation failed.", ex);
            return null;
        }
    }

    private <T> Set<T> getCustomInstances(Class<T> contract) {
        LinkedHashSet<T> sp = new LinkedHashSet<T>();
        for (Object p : this.providerInstances) {
            if (!contract.isInstance(p)) continue;
            sp.add(contract.cast(p));
        }
        return sp;
    }

    public static interface ServiceListener<T> {
        public void onAdd(T var1);
    }

    public static final class Builder {
        private final Services services;
        private Set<Class<?>> classes;
        private Set<Object> instances;

        public Builder(@Inject Services services) {
            this.services = services;
        }

        public Builder setProviderClasses(Set<Class<?>> classes) {
            this.classes = classes;
            return this;
        }

        public Builder setProviderInstances(Set<Object> instances) {
            this.instances = instances;
            return this;
        }

        public ServiceProviders build() {
            return new ServiceProviders(this.services, this.classes, this.instances);
        }
    }
}

