/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.jvnet.tigertypes.Types;

@Singleton
public class ContextInjectionResolver
implements InjectionResolver<Context> {
    @Inject
    ServiceLocator serviceLocator;

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        Type requiredType = injectee.getRequiredType();
        boolean isHk2Factory = Types.isSubClassOf(requiredType, Factory.class);
        Injectee newInjectee = isHk2Factory ? this.getInjectee(injectee, Types.getTypeArgument(requiredType, 0)) : injectee;
        ActiveDescriptor ad = this.serviceLocator.getInjecteeDescriptor(newInjectee);
        if (ad != null) {
            ServiceHandle handle = this.serviceLocator.getServiceHandle(ad);
            if (isHk2Factory) {
                return this.asFactory(handle);
            }
            return handle.getService();
        }
        return null;
    }

    private Factory asFactory(final ServiceHandle handle) {
        return new Factory(){

            public Object provide() {
                return handle.getService();
            }

            public void dispose(Object instance) {
            }
        };
    }

    private Injectee getInjectee(final Injectee injectee, final Type requiredType) {
        return new Injectee(){

            public Type getRequiredType() {
                return requiredType;
            }

            public Set<Annotation> getRequiredQualifiers() {
                return injectee.getRequiredQualifiers();
            }

            public int getPosition() {
                return injectee.getPosition();
            }

            public Class<?> getInjecteeClass() {
                return injectee.getInjecteeClass();
            }

            public AnnotatedElement getParent() {
                return injectee.getParent();
            }

            public boolean isOptional() {
                return injectee.isOptional();
            }

            public boolean isSelf() {
                return injectee.isSelf();
            }
        };
    }

    public boolean isConstructorParameterIndicator() {
        return true;
    }

    public boolean isMethodParameterIndicator() {
        return false;
    }

    public static final class Module
    extends AbstractModule {
        @Override
        protected void configure() {
            this.bind((Descriptor)BuilderHelper.link(ContextInjectionResolver.class).to(InjectionResolver.class).in(Singleton.class).build());
        }
    }
}

