/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.IOException;
import javax.inject.Singleton;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.message.internal.MessageBodyProcessingException;

@BindingPriority(value=10)
@Singleton
public class ExceptionWrapperInterceptor
implements ReaderInterceptor,
WriterInterceptor {
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        try {
            return context.proceed();
        }
        catch (WebApplicationException wae) {
            throw new MessageBodyProcessingException(LocalizationMessages.ERROR_PROCESSING_MESSAGEBODY(), wae);
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        try {
            context.proceed();
        }
        catch (WebApplicationException wae) {
            throw new MessageBodyProcessingException(LocalizationMessages.ERROR_PROCESSING_MESSAGEBODY(), wae);
        }
    }

    public static class Module
    extends AbstractModule {
        @Override
        protected void configure() {
            this.bind((Descriptor)BuilderHelper.link(ExceptionWrapperInterceptor.class).to(ReaderInterceptor.class).to(WriterInterceptor.class).in(Singleton.class).build());
        }
    }
}

