/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Function;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.spi.ExceptionMappers;

public abstract class ResponseProcessor<DATA>
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ResponseProcessor.class.getName());
    private final RequestScope requestScope;
    private volatile RequestScope.Instance scopeInstance;
    private final InvocationCallback<DATA> callback;
    private final Future<DATA> inflectedResponse;
    private final SettableFuture<DATA> processedResponse;
    private final Provider<RespondingContext<DATA>> respondingCtxProvider;
    private final Provider<ExceptionMappers> exceptionMappersProvider;

    protected ResponseProcessor(InvocationCallback<DATA> callback, Future<DATA> inflectedResponse, SettableFuture<DATA> processedResponse, Provider<RespondingContext<DATA>> respondingCtxProvider, RequestScope.Instance scopeInstance, RequestScope requestScope, Provider<ExceptionMappers> exceptionMappersProvider) {
        this.processedResponse = processedResponse;
        this.requestScope = requestScope;
        this.scopeInstance = scopeInstance;
        this.callback = callback;
        this.inflectedResponse = inflectedResponse;
        this.respondingCtxProvider = respondingCtxProvider;
        this.exceptionMappersProvider = exceptionMappersProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.requestScope.runInScope(this.scopeInstance, new Runnable(){

                @Override
                public void run() {
                    Object response;
                    block11: {
                        if (ResponseProcessor.this.inflectedResponse.isCancelled()) {
                            ResponseProcessor.this.processedResponse.cancel(true);
                            return;
                        }
                        try {
                            response = ResponseProcessor.this.inflectedResponse.get();
                        }
                        catch (Throwable ex) {
                            Throwable unwrapped = ex instanceof ExecutionException ? ex.getCause() : ex;
                            LOGGER.log(Level.FINE, "Request-to-response transformation finished with an exception.", unwrapped);
                            try {
                                response = ResponseProcessor.this.convertResponse(ResponseProcessor.this.mapException(unwrapped));
                            }
                            catch (Throwable ex2) {
                                ResponseProcessor.this.setResult(ex2);
                                return;
                            }
                            if (response != null) break block11;
                            ResponseProcessor.this.setResult(unwrapped);
                            return;
                        }
                    }
                    for (int i = 0; i < 2; ++i) {
                        try {
                            response = ResponseProcessor.this.runResponders(response);
                            break;
                        }
                        catch (Throwable ex) {
                            LOGGER.log(Level.FINE, "Responder chain execution finished with an exception.", ex);
                            if (i == 0) {
                                try {
                                    response = ResponseProcessor.this.convertResponse(ResponseProcessor.this.mapException(ex));
                                }
                                catch (Throwable ex2) {
                                    ResponseProcessor.this.setResult(ex2);
                                    return;
                                }
                            }
                            if (response != null) continue;
                            ResponseProcessor.this.setResult(ex);
                            return;
                        }
                    }
                    ResponseProcessor.this.setResult(response);
                }
            });
        }
        finally {
            this.scopeInstance.release();
        }
    }

    private DATA runResponders(DATA response) {
        Stage responder = ((RespondingContext)this.respondingCtxProvider.get()).createResponderRoot();
        if (responder != null) {
            Stage.Continuation<DATA> continuation = Stage.Continuation.of(response, responder);
            while (continuation.hasNext()) {
                continuation = continuation.next().apply(continuation.result());
            }
            return continuation.result();
        }
        return response;
    }

    protected abstract DATA convertResponse(Response var1);

    private Response mapException(Throwable exception) throws Exception {
        ExceptionMapper<?> mapper;
        Response response = null;
        if (exception instanceof MappableException) {
            exception = exception.getCause();
        }
        if (exception instanceof WebApplicationException) {
            response = ((WebApplicationException)exception).getResponse();
        }
        ExceptionMappers exceptionMappers = (ExceptionMappers)this.exceptionMappersProvider.get();
        if (!(response != null && response.hasEntity() || exceptionMappers == null || (mapper = exceptionMappers.find(exception.getClass())) == null)) {
            response = mapper.toResponse(exception);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(DATA response) {
        try {
            this.processedResponse.set(response);
        }
        finally {
            this.notifyCallback(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResult(Throwable exception) {
        try {
            this.processedResponse.setException(exception);
        }
        finally {
            this.notifyCallback(exception);
        }
    }

    private void notifyCallback(DATA response) {
        try {
            this.callback.result(response);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, LocalizationMessages.CALLBACK_METHOD_INVOCATION_FAILED("result", Thread.currentThread().getName()), ex);
        }
    }

    private void notifyCallback(Throwable exception) {
        try {
            this.callback.failure(exception);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, LocalizationMessages.CALLBACK_METHOD_INVOCATION_FAILED("failure", Thread.currentThread().getName()), ex);
        }
    }

    public static interface Builder<DATA> {
        public ResponseProcessor<DATA> build(Future<DATA> var1, SettableFuture<DATA> var2, InvocationCallback<DATA> var3, RequestScope.Instance var4);
    }

    public static interface RespondingContext<DATA> {
        public void push(Function<DATA, DATA> var1);

        public void push(ChainableStage<DATA> var1);

        public Stage<DATA> createResponderRoot();
    }
}

