/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util.collection;

import org.glassfish.jersey.internal.util.collection.Value;

public final class Values {
    private static final Value EMPTY = new Value(){

        public Object get() {
            return null;
        }
    };

    private Values() {
    }

    public static <T> Value<T> empty() {
        return EMPTY;
    }

    public static <T> Value<T> of(T value) {
        return value == null ? Values.empty() : new InstanceValue<T>(value);
    }

    public static <T> Value<T> lazy(Value<T> delegate) {
        return delegate == null ? Values.empty() : new LazyValue<T>(delegate);
    }

    private static class LazyValue<T>
    implements Value<T> {
        private final Object lock;
        private final Value<T> delegate;
        private volatile T value;

        public LazyValue(Value<T> delegate) {
            this.delegate = delegate;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            T result = this.value;
            if (result == null) {
                Object object = this.lock;
                synchronized (object) {
                    result = this.value;
                    if (result == null) {
                        this.value = result = this.delegate.get();
                    }
                }
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.delegate.equals(((LazyValue)o).delegate);
        }

        public int hashCode() {
            return this.delegate != null ? this.delegate.hashCode() : 0;
        }

        public String toString() {
            return "LazyValue{delegate=" + this.delegate.toString() + '}';
        }
    }

    private static class InstanceValue<T>
    implements Value<T> {
        private final T value;

        public InstanceValue(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.value.equals(((InstanceValue)o).value);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public String toString() {
            return "InstanceValue{value=" + this.value + '}';
        }
    }
}

