/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Objects;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Monitor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.LazyUid;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;

public abstract class AsyncInflectorAdapter<REQUEST, RESPONSE>
extends AbstractFuture<RESPONSE>
implements Inflector<REQUEST, ListenableFuture<RESPONSE>>,
InvocationContext {
    private static final Logger LOGGER = Logger.getLogger(AsyncInflectorAdapter.class.getName());
    private final LazyUid id = new LazyUid();
    private InvocationContext.State executionState = InvocationContext.State.RUNNING;
    private final Monitor executionStateMonitor = new Monitor();
    private final Monitor.Guard resumableState = new Monitor.Guard(this.executionStateMonitor){

        public boolean isSatisfied() {
            return AsyncInflectorAdapter.this.executionState == InvocationContext.State.RUNNING || AsyncInflectorAdapter.this.executionState == InvocationContext.State.SUSPENDED;
        }
    };
    private final Monitor.Guard runningState = new Monitor.Guard(this.executionStateMonitor){

        public boolean isSatisfied() {
            return AsyncInflectorAdapter.this.executionState == InvocationContext.State.RUNNING;
        }
    };
    private final Monitor.Guard cancellableState = new Monitor.Guard(this.executionStateMonitor){

        public boolean isSatisfied() {
            return AsyncInflectorAdapter.this.executionState == InvocationContext.State.RUNNING || AsyncInflectorAdapter.this.executionState == InvocationContext.State.SUSPENDED;
        }
    };
    private long defaultTimeout = 0L;
    private TimeUnit defaultTimeoutUnit = TimeUnit.MILLISECONDS;
    private AtomicReference<Response> defaultResponse = new AtomicReference();
    private AtomicReference<REQUEST> originatingRequest = new AtomicReference();
    private final Inflector<REQUEST, RESPONSE> wrapped;
    private final InvocationCallback<RESPONSE> callback;

    protected AsyncInflectorAdapter(Inflector<REQUEST, RESPONSE> wrapped, InvocationCallback<RESPONSE> callback) {
        this.wrapped = wrapped;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<RESPONSE> apply(REQUEST request) {
        block7: {
            this.originatingRequest.set(request);
            try {
                RESPONSE response = this.wrapped.apply(request);
                if (this.executionStateMonitor.enterIf(this.runningState)) {
                    try {
                        this.executionState = InvocationContext.State.RESUMED;
                        this.set(response);
                        break block7;
                    }
                    finally {
                        this.executionStateMonitor.leave();
                    }
                }
                if (response != null) {
                    LOGGER.log(Level.FINE, LocalizationMessages.REQUEST_SUSPENDED_RESPONSE_IGNORED(response));
                }
            }
            catch (Throwable t) {
                this.resume(t);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvocationContext.State state() {
        this.executionStateMonitor.enter();
        try {
            InvocationContext.State state = this.executionState;
            return state;
        }
        finally {
            this.executionStateMonitor.leave();
        }
    }

    public void resume(final Object response) {
        this.resume(new Runnable(){

            @Override
            public void run() {
                AsyncInflectorAdapter.this.set(AsyncInflectorAdapter.this.convertResponse(AsyncInflectorAdapter.this.originatingRequest.get(), AsyncInflectorAdapter.this.toJaxrsResponse(response)));
            }
        });
    }

    public void resume(final Throwable response) throws IllegalStateException {
        this.resume(new Runnable(){

            @Override
            public void run() {
                if (response instanceof Error) {
                    try {
                        AsyncInflectorAdapter.this.setException(response);
                    }
                    catch (Error error) {}
                } else {
                    AsyncInflectorAdapter.this.setException(response);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume(Runnable resumeHandler) {
        if (this.executionStateMonitor.enterIf(this.resumableState)) {
            boolean invokeCallback;
            try {
                invokeCallback = this.executionState == InvocationContext.State.SUSPENDED;
                this.executionState = InvocationContext.State.RESUMED;
            }
            finally {
                this.executionStateMonitor.leave();
            }
            try {
                resumeHandler.run();
            }
            finally {
                if (invokeCallback) {
                    this.callback.resumed();
                }
            }
        }
        throw new IllegalStateException(LocalizationMessages.ILLEGAL_INVOCATION_CONTEXT_STATE((Object)this.executionState, "resume"));
    }

    public void setSuspendTimeout(long time, TimeUnit unit) {
        this.defaultTimeout = time;
        this.defaultTimeoutUnit = unit;
    }

    @Override
    public boolean trySuspend() {
        return this._suspend(this.defaultTimeout, this.defaultTimeoutUnit, false);
    }

    public void suspend() {
        this._suspend(this.defaultTimeout, this.defaultTimeoutUnit, true);
    }

    public void suspend(long millis) {
        this._suspend(millis, TimeUnit.MILLISECONDS, true);
    }

    public void suspend(long time, TimeUnit unit) {
        this._suspend(time, unit, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean _suspend(long time, TimeUnit unit, boolean failOnError) throws IllegalStateException {
        suspendSuccessful = false;
        try {
            this.executionStateMonitor.enter();
            switch (6.$SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State[this.executionState.ordinal()]) {
                case 1: {
                    ** break;
lbl7:
                    // 1 sources

                    break;
                }
                case 2: 
                case 3: {
                    if (!failOnError) ** break;
                    throw new IllegalStateException(LocalizationMessages.ILLEGAL_INVOCATION_CONTEXT_STATE((Object)this.executionState, "suspend"));
                }
                case 4: {
                    this.executionState = InvocationContext.State.SUSPENDED;
                    suspendSuccessful = true;
                    break;
                }
                ** default:
lbl16:
                // 1 sources

                break;
            }
        }
        finally {
            this.executionStateMonitor.leave();
        }
        if (suspendSuccessful) {
            this.callback.suspended(time, unit, this);
        } else {
            AsyncInflectorAdapter.LOGGER.log(Level.FINE, LocalizationMessages.REQUEST_SUSPEND_FAILED((Object)this.executionState));
        }
        return suspendSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.executionStateMonitor.enterIf(this.cancellableState)) {
            try {
                this.executionState = InvocationContext.State.CANCELLED;
            }
            finally {
                this.executionStateMonitor.leave();
            }
            super.cancel(true);
        } else {
            LOGGER.log(Level.FINE, LocalizationMessages.REQUEST_CANCEL_FAILED((Object)this.executionState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        try {
            this.executionStateMonitor.enter();
            boolean bl = this.executionState == InvocationContext.State.SUSPENDED;
            return bl;
        }
        finally {
            this.executionStateMonitor.leave();
        }
    }

    protected void interruptTask() {
        this.callback.cancelled();
    }

    public void setResponse(Object response) {
        this.defaultResponse.set(this.toJaxrsResponse(response));
    }

    public Response getResponse() {
        return this.defaultResponse.get();
    }

    private Response toJaxrsResponse(Object response) {
        if (response instanceof Response) {
            return (Response)response;
        }
        return Response.ok((Object)response).build();
    }

    protected abstract RESPONSE convertResponse(REQUEST var1, Response var2);

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id.value()).toString();
    }

    static class 6 {
        static final /* synthetic */ int[] $SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State;

        static {
            $SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State = new int[InvocationContext.State.values().length];
            try {
                6.$SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State[InvocationContext.State.RESUMED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                6.$SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State[InvocationContext.State.SUSPENDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                6.$SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State[InvocationContext.State.CANCELLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                6.$SwitchMap$org$glassfish$jersey$process$internal$InvocationContext$State[InvocationContext.State.RUNNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static interface Builder<REQUEST, RESPONSE> {
        public AsyncInflectorAdapter<REQUEST, RESPONSE> create(Inflector<REQUEST, RESPONSE> var1, InvocationCallback<RESPONSE> var2);
    }
}

