/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.LazyUid;
import org.glassfish.jersey.process.internal.RequestScoped;

@Singleton
public class RequestScope
implements Context<RequestScoped> {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(RequestScope.class.getName()), Level.FINEST);
    private ThreadLocal<Instance> currentScopeInstance = new ThreadLocal();

    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        Instance instance = this.current();
        Object retVal = instance.get(activeDescriptor);
        if (retVal == null) {
            retVal = activeDescriptor.create(root);
            instance.put(activeDescriptor, retVal);
        }
        return retVal;
    }

    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        Instance instance = this.current();
        return instance.contains(descriptor);
    }

    public boolean supportsNullCreation() {
        return true;
    }

    public <U> U find(ActiveDescriptor<U> activeDescriptor) {
        Instance instance = this.current();
        return instance.get(activeDescriptor);
    }

    public boolean isActive() {
        return true;
    }

    public void shutdown() {
        this.currentScopeInstance = null;
    }

    public Instance current() {
        Instance scopeInstance = this.currentScopeInstance.get();
        Preconditions.checkState((scopeInstance != null ? 1 : 0) != 0, (Object)"Not inside a request scope.");
        return scopeInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance suspendCurrent() {
        Instance instance;
        Instance scopeInstance = this.currentScopeInstance.get();
        if (scopeInstance == null) {
            return null;
        }
        try {
            instance = scopeInstance.getReference();
        }
        catch (Throwable throwable) {
            logger.debugLog("Returned a new reference of the request scope instance {0}", scopeInstance);
            throw throwable;
        }
        logger.debugLog("Returned a new reference of the request scope instance {0}", scopeInstance);
        return instance;
    }

    public Instance createInstance() {
        return new Instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInScope(Instance scopeInstance, Runnable task) {
        Instance oldInstance = this.currentScopeInstance.get();
        try {
            this.currentScopeInstance.set(scopeInstance.getReference());
            task.run();
        }
        finally {
            this.currentScopeInstance.set(oldInstance);
            scopeInstance.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInScope(Runnable task) {
        Instance oldInstance = this.currentScopeInstance.get();
        Instance instance = this.createInstance();
        try {
            this.currentScopeInstance.set(instance);
            task.run();
        }
        finally {
            this.currentScopeInstance.set(oldInstance);
            instance.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Instance scopeInstance, Callable<T> task) throws Exception {
        Instance oldInstance = this.currentScopeInstance.get();
        try {
            this.currentScopeInstance.set(scopeInstance.getReference());
            T t = task.call();
            return t;
        }
        finally {
            this.currentScopeInstance.set(oldInstance);
            scopeInstance.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Callable<T> task) throws Exception {
        Instance oldInstance = this.currentScopeInstance.get();
        Instance instance = this.createInstance();
        try {
            this.currentScopeInstance.set(instance);
            T t = task.call();
            return t;
        }
        finally {
            this.currentScopeInstance.set(oldInstance);
            instance.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Instance scopeInstance, Producer<T> task) {
        Instance oldInstance = this.currentScopeInstance.get();
        try {
            this.currentScopeInstance.set(scopeInstance.getReference());
            T t = task.call();
            return t;
        }
        finally {
            this.currentScopeInstance.set(oldInstance);
            scopeInstance.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Producer<T> task) {
        Instance oldInstance = this.currentScopeInstance.get();
        Instance instance = this.createInstance();
        try {
            this.currentScopeInstance.set(instance);
            T t = task.call();
            return t;
        }
        finally {
            this.currentScopeInstance.set(oldInstance);
            instance.release();
        }
    }

    public static final class Instance {
        private final LazyUid id = new LazyUid();
        private final Map<ActiveDescriptor<?>, Object> store = new HashMap();
        private final AtomicInteger referenceCounter = new AtomicInteger(1);

        private Instance() {
        }

        private Instance getReference() {
            this.referenceCounter.incrementAndGet();
            return this;
        }

        public <T> T get(ActiveDescriptor<T> inhabitant) {
            return (T)this.store.get(inhabitant);
        }

        public <T> T put(ActiveDescriptor<T> descriptor, T value) {
            Preconditions.checkState((!this.store.containsKey(descriptor) ? 1 : 0) != 0, (String)"An instance for the descriptor %s was already seeded in this scope. Old instance: %s New instance: %s", (Object[])new Object[]{descriptor, this.store.get(descriptor), value});
            return (T)this.store.put(descriptor, value);
        }

        public <T> boolean contains(ActiveDescriptor<T> provider) {
            return this.store.containsKey(provider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            if (this.referenceCounter.decrementAndGet() < 1) {
                try {
                    this.store.clear();
                }
                catch (Throwable throwable) {
                    logger.debugLog("Released scope instance {0}", this);
                    throw throwable;
                }
                logger.debugLog("Released scope instance {0}", this);
            }
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("id", (Object)this.id.value()).add("referenceCounter", this.referenceCounter.get()).add("store size", this.store.size()).toString();
        }
    }

    public static interface Producer<T>
    extends Callable<T> {
        @Override
        public T call();
    }

    public static class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            this.bind(new RequestScope()).to(RequestScope.class);
        }
    }
}

