/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.Config;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.KeyComparator;
import org.glassfish.jersey.internal.util.KeyComparatorHashMap;
import org.glassfish.jersey.internal.util.KeyComparatorLinkedHashMap;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.ReaderInterceptorExecutor;
import org.glassfish.jersey.message.internal.WriterInterceptorExecutor;
import org.glassfish.jersey.process.internal.PriorityComparator;
import org.jvnet.hk2.annotations.Optional;

public class MessageBodyFactory
implements MessageBodyWorkers {
    public static final KeyComparator<MediaType> MEDIA_TYPE_COMPARATOR = new KeyComparator<MediaType>(){
        private static final long serialVersionUID = 2727819828630827763L;

        @Override
        public boolean equals(MediaType x, MediaType y) {
            return x.getType().equalsIgnoreCase(y.getType()) && x.getSubtype().equalsIgnoreCase(y.getSubtype());
        }

        @Override
        public int hash(MediaType k) {
            return k.getType().toLowerCase().hashCode() + k.getSubtype().toLowerCase().hashCode();
        }

        @Override
        public int compare(MediaType o1, MediaType o2) {
            if (this.equals(o1, o2)) {
                return 0;
            }
            if (o1.isWildcardType() ^ o2.isWildcardType()) {
                return o1.isWildcardType() ? 1 : -1;
            }
            if (o1.isWildcardSubtype() ^ o2.isWildcardSubtype()) {
                return o1.isWildcardSubtype() ? 1 : -1;
            }
            return 0;
        }
    };
    private final ServiceLocator locator;
    private final Boolean legacyProviderOrdering;
    private List<ReaderInterceptor> readerInterceptors;
    private List<WriterInterceptor> writerInterceptors;
    private List<MessageBodyWorkerPair<MessageBodyReader>> readers;
    private List<MessageBodyWorkerPair<MessageBodyWriter>> writers;
    private final Map<MediaType, List<MessageBodyReader>> readersCache = new KeyComparatorHashMap<MediaType, List<MessageBodyReader>>(MEDIA_TYPE_COMPARATOR);
    private final Map<MediaType, List<MessageBodyWriter>> writersCache = new KeyComparatorHashMap<MediaType, List<MessageBodyWriter>>(MEDIA_TYPE_COMPARATOR);
    private final Map<TypeMediaTypePair, List<MessageBodyWorkerPair<MessageBodyReader>>> mbrLookupCache = new ConcurrentHashMap<TypeMediaTypePair, List<MessageBodyWorkerPair<MessageBodyReader>>>();
    private final Map<TypeMediaTypePair, List<MessageBodyWorkerPair<MessageBodyWriter>>> mbwLookupCache = new ConcurrentHashMap<TypeMediaTypePair, List<MessageBodyWorkerPair<MessageBodyWriter>>>();

    @Override
    public List<ReaderInterceptor> getReaderInterceptors() {
        return this.readerInterceptors;
    }

    @Override
    public List<WriterInterceptor> getWriterInterceptors() {
        return this.writerInterceptors;
    }

    @Inject
    public MessageBodyFactory(ServiceLocator locator, @Optional Config config) {
        this.locator = locator;
        this.legacyProviderOrdering = config != null && config.isProperty("jersey.config.workers.legacyOrdering");
        this.initReaders();
        this.initWriters();
        this.initInterceptors();
    }

    private void initInterceptors() {
        List _readerInterceptors = this.locator.getAllServices(ReaderInterceptor.class, new Annotation[0]);
        Collections.sort(_readerInterceptors, new PriorityComparator(PriorityComparator.Order.ASCENDING));
        this.readerInterceptors = Collections.unmodifiableList(_readerInterceptors);
        List _writerInterceptors = this.locator.getAllServices(WriterInterceptor.class, new Annotation[0]);
        Collections.sort(_writerInterceptors, new PriorityComparator(PriorityComparator.Order.ASCENDING));
        this.writerInterceptors = Collections.unmodifiableList(_writerInterceptors);
    }

    private void initReaders() {
        this.readers = new ArrayList<MessageBodyWorkerPair<MessageBodyReader>>();
        Set<MessageBodyReader> customProviders = Providers.getCustomProviders(this.locator, MessageBodyReader.class);
        Set<MessageBodyReader> providers = Providers.getProviders(this.locator, MessageBodyReader.class);
        this.initReaders(this.readers, customProviders, true);
        providers.removeAll(customProviders);
        this.initReaders(this.readers, providers, false);
        if (this.legacyProviderOrdering.booleanValue()) {
            Collections.sort(this.readers, new LegacyWorkerComparator(MessageBodyReader.class));
            for (MessageBodyWorkerPair<MessageBodyReader> messageBodyWorkerPair : this.readers) {
                for (MediaType mt : messageBodyWorkerPair.types) {
                    List<MessageBodyReader> readerList = this.readersCache.get(mt);
                    if (readerList == null) {
                        readerList = new ArrayList<MessageBodyReader>();
                        this.readersCache.put(mt, readerList);
                    }
                    readerList.add((MessageBodyReader)messageBodyWorkerPair.provider);
                }
            }
        }
    }

    private void initReaders(List<MessageBodyWorkerPair<MessageBodyReader>> readers, Set<MessageBodyReader> providersSet, boolean custom) {
        for (MessageBodyReader provider : providersSet) {
            List<MediaType> values = MediaTypes.createFrom(provider.getClass().getAnnotation(Consumes.class));
            MessageBodyWorkerPair readerPair = new MessageBodyWorkerPair(provider, values, custom);
            readers.add(readerPair);
        }
    }

    private void initWriters() {
        this.writers = new ArrayList<MessageBodyWorkerPair<MessageBodyWriter>>();
        Set<MessageBodyWriter> customProviders = Providers.getCustomProviders(this.locator, MessageBodyWriter.class);
        Set<MessageBodyWriter> providers = Providers.getProviders(this.locator, MessageBodyWriter.class);
        this.initWriters(this.writers, customProviders, true);
        providers.removeAll(customProviders);
        this.initWriters(this.writers, providers, false);
        if (this.legacyProviderOrdering.booleanValue()) {
            Collections.sort(this.writers, new LegacyWorkerComparator(MessageBodyWriter.class));
            for (MessageBodyWorkerPair<MessageBodyWriter> messageBodyWorkerPair : this.writers) {
                for (MediaType mt : messageBodyWorkerPair.types) {
                    List<MessageBodyWriter> writerList = this.writersCache.get(mt);
                    if (writerList == null) {
                        writerList = new ArrayList<MessageBodyWriter>();
                        this.writersCache.put(mt, writerList);
                    }
                    writerList.add((MessageBodyWriter)messageBodyWorkerPair.provider);
                }
            }
        }
    }

    private void initWriters(List<MessageBodyWorkerPair<MessageBodyWriter>> writers, Set<MessageBodyWriter> providersSet, boolean custom) {
        for (MessageBodyWriter provider : providersSet) {
            List<MediaType> values = MediaTypes.createFrom(provider.getClass().getAnnotation(Produces.class));
            MessageBodyWorkerPair workerPair = new MessageBodyWorkerPair(provider, values, custom);
            writers.add(workerPair);
        }
    }

    @Override
    public Map<MediaType, List<MessageBodyReader>> getReaders(MediaType mediaType) {
        KeyComparatorLinkedHashMap<MediaType, List<MessageBodyReader>> subSet = new KeyComparatorLinkedHashMap<MediaType, List<MessageBodyReader>>(MEDIA_TYPE_COMPARATOR);
        this.getCompatibleProvidersMap(mediaType, this.readers, subSet);
        return subSet;
    }

    @Override
    public Map<MediaType, List<MessageBodyWriter>> getWriters(MediaType mediaType) {
        KeyComparatorLinkedHashMap<MediaType, List<MessageBodyWriter>> subSet = new KeyComparatorLinkedHashMap<MediaType, List<MessageBodyWriter>>(MEDIA_TYPE_COMPARATOR);
        this.getCompatibleProvidersMap(mediaType, this.writers, subSet);
        return subSet;
    }

    @Override
    public String readersToString(Map<MediaType, List<MessageBodyReader>> readers) {
        return this.toString(readers);
    }

    @Override
    public String writersToString(Map<MediaType, List<MessageBodyWriter>> writers) {
        return this.toString(writers);
    }

    private <T> String toString(Map<MediaType, List<T>> set) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Map.Entry<MediaType, List<T>> e : set.entrySet()) {
            pw.append(e.getKey().toString()).println(" ->");
            for (T t : e.getValue()) {
                pw.append("  ").println(t.getClass().getName());
            }
        }
        pw.flush();
        return sw.toString();
    }

    @Override
    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        MessageBodyReader<T> p = null;
        if (this.legacyProviderOrdering.booleanValue()) {
            if (mediaType != null && (p = this._getMessageBodyReader(c, t, as, mediaType, mediaType)) == null) {
                p = this._getMessageBodyReader(c, t, as, mediaType, MediaTypes.getTypeWildCart(mediaType));
            }
            if (p == null) {
                p = this._getMessageBodyReader(c, t, as, mediaType, MediaTypes.GENERAL_MEDIA_TYPE);
            }
        } else {
            p = this._getMessageBodyReader(c, t, as, mediaType, this.readers);
        }
        return p;
    }

    @Override
    public <T> List<MediaType> getMessageBodyReaderMediaTypes(Class<T> type, Type genericType, Annotation[] annotations) {
        ArrayList<MediaType> mtl = new ArrayList<MediaType>();
        for (MessageBodyWorkerPair<MessageBodyReader> mbrp : this.readers) {
            for (MediaType mt : mbrp.types) {
                if (!((MessageBodyReader)mbrp.provider).isReadable(type, genericType, annotations, mt)) continue;
                mtl.addAll(mbrp.types);
            }
        }
        Collections.sort(mtl, MediaTypes.MEDIA_TYPE_COMPARATOR);
        return mtl;
    }

    private <T> boolean isCompatible(Class<T> workerClass, MessageBodyWorkerPair<T> messageBodyWorkerPair, Class c, MediaType mediaType) {
        if (messageBodyWorkerPair.providerClassParam == null) {
            ReflectionHelper.DeclaringClassInterfacePair p = ReflectionHelper.getClass(messageBodyWorkerPair.provider.getClass(), workerClass);
            Class[] classArgs = ReflectionHelper.getParameterizedClassArguments(p);
            Class<?> clazz = messageBodyWorkerPair.providerClassParam = classArgs != null ? classArgs[0] : null;
        }
        if (messageBodyWorkerPair.providerClassParam == null) {
            messageBodyWorkerPair.providerClassParam = Object.class;
        }
        if (messageBodyWorkerPair.providerClassParam.equals(Object.class) || messageBodyWorkerPair.providerClassParam.isAssignableFrom(c) || c.isAssignableFrom(messageBodyWorkerPair.providerClassParam)) {
            for (MediaType mt : messageBodyWorkerPair.types) {
                if (mediaType == null) {
                    return true;
                }
                if (!MediaTypes.typeEqual(mediaType, mt) && !MediaTypes.typeEqual(MediaTypes.getTypeWildCart(mediaType), mt) && !MediaTypes.typeEqual(MediaTypes.GENERAL_MEDIA_TYPE, mt)) continue;
                return true;
            }
        }
        return false;
    }

    private <T> MessageBodyReader<T> _getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType, List<MessageBodyWorkerPair<MessageBodyReader>> workers) {
        List<MessageBodyWorkerPair<MessageBodyReader>> readers = this.mbrLookupCache.get(new TypeMediaTypePair(c, mediaType));
        if (readers == null) {
            readers = new ArrayList<MessageBodyWorkerPair<MessageBodyReader>>();
            for (MessageBodyWorkerPair<MessageBodyReader> mbwp : workers) {
                if (!this.isCompatible(MessageBodyReader.class, mbwp, c, mediaType)) continue;
                readers.add(mbwp);
            }
            Collections.sort(readers, new WorkerComparator(c, mediaType));
            this.mbrLookupCache.put(new TypeMediaTypePair(c, mediaType), readers);
        }
        if (readers.isEmpty()) {
            return null;
        }
        for (MessageBodyWorkerPair<MessageBodyReader> mbwp : readers) {
            if (!((MessageBodyReader)mbwp.provider).isReadable(c, t, as, mediaType)) continue;
            return (MessageBodyReader)mbwp.provider;
        }
        return null;
    }

    private <T> MessageBodyReader<T> _getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType, MediaType lookup) {
        List<MessageBodyReader> readers = this.readersCache.get(lookup);
        if (readers == null) {
            return null;
        }
        for (MessageBodyReader p : readers) {
            if (!p.isReadable(c, t, as, mediaType)) continue;
            return p;
        }
        return null;
    }

    @Override
    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        MessageBodyWriter<T> p = null;
        if (this.legacyProviderOrdering.booleanValue()) {
            if (mediaType != null && (p = this._getMessageBodyWriter(c, t, as, mediaType, mediaType)) == null) {
                p = this._getMessageBodyWriter(c, t, as, mediaType, MediaTypes.getTypeWildCart(mediaType));
            }
            if (p == null) {
                p = this._getMessageBodyWriter(c, t, as, mediaType, MediaTypes.GENERAL_MEDIA_TYPE);
            }
        } else {
            p = this._getMessageBodyWriter(c, t, as, mediaType, this.writers);
        }
        return p;
    }

    private <T> MessageBodyWriter<T> _getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType, List<MessageBodyWorkerPair<MessageBodyWriter>> workers) {
        List<MessageBodyWorkerPair<MessageBodyWriter>> writers = this.mbwLookupCache.get(new TypeMediaTypePair(c, mediaType));
        if (writers == null) {
            writers = new ArrayList<MessageBodyWorkerPair<MessageBodyWriter>>();
            for (MessageBodyWorkerPair<MessageBodyWriter> mbwp : workers) {
                if (!this.isCompatible(MessageBodyWriter.class, mbwp, c, mediaType)) continue;
                writers.add(mbwp);
            }
            Collections.sort(writers, new WorkerComparator(c, mediaType));
            this.mbwLookupCache.put(new TypeMediaTypePair(c, mediaType), writers);
        }
        if (writers.isEmpty()) {
            return null;
        }
        for (MessageBodyWorkerPair<MessageBodyWriter> mbwp : writers) {
            if (!((MessageBodyWriter)mbwp.provider).isWriteable(c, t, as, mediaType)) continue;
            return (MessageBodyWriter)mbwp.provider;
        }
        return null;
    }

    private <T> MessageBodyWriter<T> _getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType, MediaType lookup) {
        List<MessageBodyWriter> writers = this.writersCache.get(lookup);
        if (writers == null) {
            return null;
        }
        for (MessageBodyWriter p : writers) {
            if (!p.isWriteable(c, t, as, mediaType)) continue;
            return p;
        }
        return null;
    }

    private <T> void getCompatibleProvidersMap(MediaType mediaType, List<MessageBodyWorkerPair<T>> set, Map<MediaType, List<T>> subSet) {
        if (mediaType.isWildcardType()) {
            this.getCompatibleProvidersList(mediaType, set, subSet);
        } else if (mediaType.isWildcardSubtype()) {
            this.getCompatibleProvidersList(mediaType, set, subSet);
            this.getCompatibleProvidersList(MediaTypes.GENERAL_MEDIA_TYPE, set, subSet);
        } else {
            this.getCompatibleProvidersList(mediaType, set, subSet);
            this.getCompatibleProvidersList(MediaTypes.getTypeWildCart(mediaType), set, subSet);
            this.getCompatibleProvidersList(MediaTypes.GENERAL_MEDIA_TYPE, set, subSet);
        }
    }

    private <T> void getCompatibleProvidersList(MediaType mediaType, List<MessageBodyWorkerPair<T>> set, Map<MediaType, List<T>> subSet) {
        ArrayList providers = new ArrayList();
        for (MessageBodyWorkerPair<T> mbpp : set) {
            if (!mbpp.types.contains(mediaType)) continue;
            providers.add(mbpp.provider);
        }
        if (!providers.isEmpty()) {
            subSet.put(mediaType, Collections.unmodifiableList(providers));
        }
    }

    @Override
    public <T> List<MediaType> getMessageBodyWriterMediaTypes(Class<T> c, Type t, Annotation[] as) {
        ArrayList<MediaType> mtl = new ArrayList<MediaType>();
        for (MessageBodyWorkerPair<MessageBodyWriter> mbwp : this.writers) {
            for (MediaType mt : mbwp.types) {
                if (!((MessageBodyWriter)mbwp.provider).isWriteable(c, t, as, mt)) continue;
                mtl.addAll(mbwp.types);
            }
        }
        Collections.sort(mtl, MediaTypes.MEDIA_TYPE_COMPARATOR);
        return mtl;
    }

    @Override
    public <T> MediaType getMessageBodyWriterMediaType(Class<T> c, Type t, Annotation[] as, List<MediaType> acceptableMediaTypes) {
        for (MediaType acceptable : acceptableMediaTypes) {
            for (MessageBodyWorkerPair<MessageBodyWriter> mbwp : this.writers) {
                for (MediaType mt : mbwp.types) {
                    if (!mt.isCompatible(acceptable) || !((MessageBodyWriter)mbwp.provider).isWriteable(c, t, as, acceptable)) continue;
                    return MediaTypes.mostSpecific(mt, acceptable);
                }
            }
        }
        return null;
    }

    @Override
    public <T> Object readFrom(Class<T> rawType, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, PropertiesDelegate propertiesDelegate, InputStream entityStream, boolean intercept) throws WebApplicationException, IOException {
        ReaderInterceptorExecutor executor = new ReaderInterceptorExecutor(rawType, type, annotations, mediaType, httpHeaders, propertiesDelegate, entityStream, this, intercept);
        return executor.proceed();
    }

    @Override
    public <T> OutputStream writeTo(Object t, Class<T> rawType, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, PropertiesDelegate propertiesDelegate, OutputStream entityStream, MessageBodyWorkers.MessageBodySizeCallback sizeCallback, boolean intercept) throws IOException, WebApplicationException {
        return this.writeTo(t, rawType, type, annotations, mediaType, httpHeaders, propertiesDelegate, entityStream, sizeCallback, intercept, true);
    }

    @Override
    public <T> OutputStream writeTo(Object t, Class<T> rawType, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, PropertiesDelegate propertiesDelegate, OutputStream entityStream, MessageBodyWorkers.MessageBodySizeCallback sizeCallback, boolean intercept, boolean writeEntity) throws IOException, WebApplicationException {
        WriterInterceptorExecutor executor = new WriterInterceptorExecutor(t, rawType, type, annotations, mediaType, httpHeaders, propertiesDelegate, entityStream, this, sizeCallback, intercept, writeEntity);
        executor.proceed();
        return executor.getOutputStream();
    }

    private class TypeMediaTypePair {
        final Class<?> clazz;
        final MediaType mediaType;

        private TypeMediaTypePair(Class<?> clazz, MediaType mediaType) {
            this.clazz = clazz;
            this.mediaType = mediaType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeMediaTypePair that = (TypeMediaTypePair)o;
            return !(this.clazz == null ? that.clazz != null : !this.clazz.equals(that.clazz)) && !(this.mediaType == null ? that.mediaType != null : !this.mediaType.equals((Object)that.mediaType));
        }

        public int hashCode() {
            int result = this.clazz != null ? this.clazz.hashCode() : 0;
            result = 31 * result + (this.mediaType != null ? this.mediaType.hashCode() : 0);
            return result;
        }
    }

    private static class LegacyWorkerComparator<T>
    implements Comparator<MessageBodyWorkerPair<T>> {
        final DeclarationDistanceComparator<T> distanceComparator;

        private LegacyWorkerComparator(Class<T> type) {
            this.distanceComparator = new DeclarationDistanceComparator<T>(type);
        }

        @Override
        public int compare(MessageBodyWorkerPair<T> mbwp1, MessageBodyWorkerPair<T> mbwp2) {
            if (mbwp1.custom ^ mbwp2.custom) {
                return mbwp1.custom != false ? -1 : 1;
            }
            int mediaTypeComparison = MEDIA_TYPE_COMPARATOR.compare(mbwp1.types.get(0), mbwp2.types.get(0));
            if (mediaTypeComparison != 0) {
                return mediaTypeComparison;
            }
            return this.distanceComparator.compare(mbwp1.provider, mbwp2.provider);
        }
    }

    private static class WorkerComparator<T>
    implements Comparator<MessageBodyWorkerPair<T>> {
        final Class wantedType;
        final MediaType wantedMediaType;

        private WorkerComparator(Class wantedType, MediaType wantedMediaType) {
            this.wantedType = wantedType;
            this.wantedMediaType = wantedMediaType;
        }

        @Override
        public int compare(MessageBodyWorkerPair<T> mbwp1, MessageBodyWorkerPair<T> mbwp2) {
            int distance = this.compareTypeDistances(mbwp1.providerClassParam, mbwp2.providerClassParam);
            if (distance != 0) {
                return distance;
            }
            int mediaTypeComparison = this.getMediaTypeDistance(this.wantedMediaType, mbwp1.types) - this.getMediaTypeDistance(this.wantedMediaType, mbwp2.types);
            if (mediaTypeComparison != 0) {
                return mediaTypeComparison;
            }
            if (mbwp1.custom ^ mbwp2.custom) {
                return mbwp1.custom != false ? 1 : -1;
            }
            return 0;
        }

        private int getMediaTypeDistance(MediaType wanted, List<MediaType> mtl) {
            if (wanted == null) {
                return 0;
            }
            int distance = 2;
            for (MediaType mt : mtl) {
                if (MediaTypes.typeEqual(wanted, mt)) {
                    return 0;
                }
                if (distance <= 1 || !MediaTypes.typeEqual(MediaTypes.getTypeWildCart(wanted), mt)) continue;
                distance = 1;
            }
            return distance;
        }

        private int compareTypeDistances(Class<?> providerClassParam1, Class<?> providerClassParam2) {
            return this.getTypeDistance(providerClassParam1) - this.getTypeDistance(providerClassParam2);
        }

        private int getTypeDistance(Class<?> classParam) {
            Class tmp1 = this.wantedType;
            Class<?> tmp2 = classParam;
            int distance = 0;
            while (!this.wantedType.equals(tmp2) && !classParam.equals(tmp1)) {
                ++distance;
                if (tmp2 != null) {
                    tmp2 = tmp2.getSuperclass();
                }
                if (tmp1 != null) {
                    tmp1 = tmp1.getSuperclass();
                }
                if (tmp2 != null || tmp1 != null) continue;
                return Integer.MAX_VALUE;
            }
            return distance;
        }
    }

    private static class DeclarationDistanceComparator<T>
    implements Comparator<T> {
        private final Class<T> declared;
        private final Map<Class, Integer> distanceMap = new HashMap<Class, Integer>();

        DeclarationDistanceComparator(Class<T> declared) {
            this.declared = declared;
        }

        @Override
        public int compare(T o1, T o2) {
            int d1 = this.getDistance(o1);
            int d2 = this.getDistance(o2);
            return d2 - d1;
        }

        private int getDistance(T t) {
            Integer distance = this.distanceMap.get(t.getClass());
            if (distance != null) {
                return distance;
            }
            distance = 0;
            for (Class a = (as = ReflectionHelper.getParameterizedClassArguments(p = ReflectionHelper.getClass(t.getClass(), this.declared))) != null ? as[0] : null; a != null && a != Object.class; a = a.getSuperclass()) {
                Integer n = distance;
                Integer n2 = distance = Integer.valueOf(distance + 1);
            }
            this.distanceMap.put(t.getClass(), distance);
            return distance;
        }
    }

    private static class MessageBodyWorkerPair<T> {
        final T provider;
        final List<MediaType> types;
        final Boolean custom;
        Class<?> providerClassParam = null;

        private MessageBodyWorkerPair(T provider, List<MediaType> types, Boolean custom) {
            this.provider = provider;
            this.types = types;
            this.custom = custom;
        }
    }

    public static class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            this.bindAsContract(MessageBodyFactory.class).to(MessageBodyWorkers.class).in(Singleton.class);
        }
    }
}

