/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import javax.inject.Inject;
import javax.xml.parsers.SAXParserFactory;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.PerThread;
import org.glassfish.jersey.Config;
import org.glassfish.jersey.message.internal.SecureSaxParserFactory;

public class SaxParserFactoryInjectionProvider
implements Factory<SAXParserFactory> {
    private final Config config;

    @Inject
    public SaxParserFactoryInjectionProvider(Config config) {
        this.config = config;
    }

    @PerThread
    public SAXParserFactory provide() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        if (!this.config.isProperty("jersey.config.xml.security.disable")) {
            factory = new SecureSaxParserFactory(factory);
        }
        return factory;
    }

    public void dispose(SAXParserFactory instance) {
    }
}

