/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import deprecated.javax.ws.rs.DynamicBinder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.CustomAnnotationImpl;
import org.glassfish.jersey.internal.inject.ProviderToService;
import org.glassfish.jersey.spi.Contract;

public class Providers {
    private static final Set<Class<?>> JAX_RS_PROVIDER_INTERFACE_WHITELIST = Providers.getJaxRsProviderInterfaces();

    private Providers() {
    }

    public static <T> Factory<T> factoryOf(final T instance) {
        return new Factory<T>(){

            public T provide() {
                return instance;
            }

            public void dispose(T instance2) {
            }
        };
    }

    public static <T> Set<T> getProviders(ServiceLocator locator, Class<T> contract) {
        List<ServiceHandle<T>> hk2Providers = Providers.getAllServiceHandles(locator, contract, new Annotation[0]);
        return Providers.getClasses(hk2Providers);
    }

    public static <T> Set<T> getCustomProviders(ServiceLocator locator, Class<T> contract) {
        List<ServiceHandle<T>> hk2Providers = Providers.getAllServiceHandles(locator, contract, new CustomAnnotationImpl());
        return Providers.getClasses(hk2Providers);
    }

    public static <T> List<T> getAllProviders(ServiceLocator locator, Class<T> contract) {
        List<ServiceHandle<T>> providers = Providers.getAllServiceHandles(locator, contract, new CustomAnnotationImpl());
        providers.addAll(Providers.getAllServiceHandles(locator, contract, new Annotation[0]));
        LinkedHashMap providerMap = Maps.newLinkedHashMap();
        for (ServiceHandle<T> provider : providers) {
            ActiveDescriptor key = provider.getActiveDescriptor();
            if (providerMap.containsKey(key)) continue;
            providerMap.put(key, provider);
        }
        return new ArrayList<T>(Providers.getClasses(providerMap.values()));
    }

    private static <T> List<ServiceHandle<T>> getAllServiceHandles(ServiceLocator locator, Class<T> contract, Annotation ... qualifiers) {
        List allServiceHandles = qualifiers == null ? locator.getAllServiceHandles(contract, new Annotation[0]) : locator.getAllServiceHandles(contract, qualifiers);
        ArrayList<ServiceHandle<T>> serviceHandles = new ArrayList<ServiceHandle<T>>();
        for (ServiceHandle handle : allServiceHandles) {
            serviceHandles.add(handle);
        }
        return serviceHandles;
    }

    public static <T> List<T> getAllProviders(ServiceLocator locator, Class<T> contract, Comparator<T> comparator) {
        List<T> providers = Providers.getAllProviders(locator, contract);
        Collections.sort(providers, comparator);
        return providers;
    }

    private static <T> Set<T> getClasses(Collection<ServiceHandle<T>> hk2Providers) {
        if (hk2Providers.isEmpty()) {
            return Sets.newLinkedHashSet();
        }
        return Sets.newLinkedHashSet((Iterable)Collections2.transform(hk2Providers, new ProviderToService()));
    }

    public static <T> SortedSet<T> getProviders(ServiceLocator locator, Class<T> contract, Comparator<T> comparator) {
        List<ServiceHandle<T>> hk2Providers = Providers.getAllServiceHandles(locator, contract, new Annotation[0]);
        if (hk2Providers.isEmpty()) {
            return Sets.newTreeSet(comparator);
        }
        TreeSet set = Sets.newTreeSet(comparator);
        set.addAll(Collections2.transform(hk2Providers, new ProviderToService()));
        return set;
    }

    public static Set<Class<?>> getProviderContracts(Class<?> clazz) {
        HashSet contracts = new HashSet();
        Providers.computeProviderContracts(clazz, contracts);
        return contracts;
    }

    private static void computeProviderContracts(Class<?> clazz, Set<Class<?>> contracts) {
        for (Class<?> contract : Providers.getImplementedContracts(clazz)) {
            if (Providers.isProviderContract(contract)) {
                contracts.add(contract);
            }
            Providers.computeProviderContracts(contract, contracts);
        }
    }

    private static boolean isProviderContract(Class clazz) {
        return JAX_RS_PROVIDER_INTERFACE_WHITELIST.contains(clazz) || clazz.isAnnotationPresent(Contract.class);
    }

    private static Set<Class<?>> getJaxRsProviderInterfaces() {
        Set<Class<?>> interfaces = Collections.newSetFromMap(new ConcurrentHashMap());
        interfaces.add(ContextResolver.class);
        interfaces.add(ExceptionMapper.class);
        interfaces.add(MessageBodyReader.class);
        interfaces.add(MessageBodyWriter.class);
        interfaces.add(javax.ws.rs.ext.Providers.class);
        interfaces.add(RuntimeDelegate.HeaderDelegate.class);
        interfaces.add(ReaderInterceptor.class);
        interfaces.add(WriterInterceptor.class);
        interfaces.add(ContainerRequestFilter.class);
        interfaces.add(ContainerResponseFilter.class);
        interfaces.add(ClientResponseFilter.class);
        interfaces.add(ClientRequestFilter.class);
        interfaces.add(DynamicBinder.class);
        interfaces.add(DynamicFeature.class);
        return interfaces;
    }

    private static List<Class<?>> getImplementedContracts(Class<?> clazz) {
        LinkedList list = new LinkedList();
        Collections.addAll(list, clazz.getInterfaces());
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            list.add(superclass);
        }
        return list;
    }

    public static boolean isProvider(Class<?> clazz) {
        return Providers.findFirstProviderContract(clazz);
    }

    private static boolean findFirstProviderContract(Class<?> clazz) {
        for (Class<?> contract : Providers.getImplementedContracts(clazz)) {
            if (Providers.isProviderContract(contract)) {
                return true;
            }
            if (!Providers.findFirstProviderContract(contract)) continue;
            return true;
        }
        return false;
    }
}

