/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.model.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Feature;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.model.internal.FeatureBag;

public class FeatureConfig
implements Configurable {
    private final Configurable delegate;
    private final List<FeatureBag.RegisteredFeature> unprocessedRegisteredFeatures = Lists.newLinkedList();

    public FeatureConfig(Configurable delegate) {
        this.delegate = delegate;
    }

    public Map<String, Object> getProperties() {
        return this.delegate.getProperties();
    }

    public Object getProperty(String name) {
        return this.delegate.getProperty(name);
    }

    public Configurable setProperties(Map<String, ?> properties) {
        return this.delegate.setProperties(properties);
    }

    public Configurable setProperty(String name, Object value) {
        return this.delegate.setProperty(name, value);
    }

    public Collection<Feature> getFeatures() {
        return this.delegate.getFeatures();
    }

    public Set<Class<?>> getProviderClasses() {
        return this.delegate.getProviderClasses();
    }

    public Set<Object> getProviderInstances() {
        return this.delegate.getProviderInstances();
    }

    public Configurable register(Class<?> providerClass) {
        return this.register(providerClass, -1, Providers.getProviderContracts(providerClass));
    }

    public Configurable register(Class<?> providerClass, int bindingPriority) {
        return this.register(providerClass, bindingPriority, Providers.getProviderContracts(providerClass));
    }

    public <T> Configurable register(Class<T> providerClass, Class<? super T> ... contracts) {
        return this.register(providerClass, -1, Sets.newLinkedHashSet(Arrays.asList(contracts)));
    }

    public <T> Configurable register(Class<T> providerClass, int bindingPriority, Class<? super T> ... contracts) {
        return this.register(providerClass, bindingPriority, Sets.newLinkedHashSet(Arrays.asList(contracts)));
    }

    public Configurable register(Object provider) {
        return this.register(provider, -1, Providers.getProviderContracts(provider.getClass()));
    }

    public Configurable register(Object provider, int bindingPriority) {
        return this.register(provider, bindingPriority, Providers.getProviderContracts(provider.getClass()));
    }

    public <T> Configurable register(Object provider, Class<? super T> ... contracts) {
        return this.register(provider, -1, Sets.newLinkedHashSet(Arrays.asList(contracts)));
    }

    public <T> Configurable register(Object provider, int bindingPriority, Class<? super T> ... contracts) {
        return this.register(provider, bindingPriority, Sets.newLinkedHashSet(Arrays.asList(contracts)));
    }

    private Configurable register(Object provider, int bindingPriority, Set<Class<?>> contracts) {
        if (contracts.contains(Feature.class)) {
            if (provider instanceof Feature) {
                this.unprocessedRegisteredFeatures.add(new FeatureBag.RegisteredFeature(null, (Feature)provider));
            }
            contracts.remove(Feature.class);
            if (contracts.isEmpty()) {
                return this;
            }
        }
        return this.delegate.register(provider, bindingPriority, contracts.toArray(new Class[contracts.size()]));
    }

    private <T> Configurable register(Class<T> providerClass, int bindingPriority, Set<Class<?>> contracts) {
        if (contracts.contains(Feature.class)) {
            if (Feature.class.isAssignableFrom(providerClass)) {
                this.unprocessedRegisteredFeatures.add(new FeatureBag.RegisteredFeature(providerClass, null));
            }
            contracts.remove(Feature.class);
            if (contracts.isEmpty()) {
                return this;
            }
        }
        return this.delegate.register(providerClass, bindingPriority, contracts.toArray(new Class[contracts.size()]));
    }

    public Collection<FeatureBag.RegisteredFeature> getUnprocessedFeatures() {
        return this.unprocessedRegisteredFeatures;
    }
}

