/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.spi.RequestExecutorsProvider;
import org.glassfish.jersey.spi.ResponseExecutorsProvider;

@Singleton
public abstract class ExecutorsFactory<REQUEST> {
    private final ServiceLocator locator;
    private static final Logger LOGGER = Logger.getLogger(ExecutorsFactory.class.getName());

    public ExecutorsFactory(ServiceLocator locator) {
        this.locator = locator;
    }

    protected ExecutorService getInitialRequestingExecutor(RequestExecutorsProvider defaultProvider) {
        for (RequestExecutorsProvider provider : Providers.getAllProviders(this.locator, RequestExecutorsProvider.class)) {
            ExecutorService requestingExecutor = provider.getRequestingExecutor();
            if (requestingExecutor == null) continue;
            LOGGER.config(LocalizationMessages.USING_CUSTOM_REQUEST_EXECUTOR(requestingExecutor.getClass().getName(), provider.getClass().getName()));
            return requestingExecutor;
        }
        ExecutorService defaultExecutor = defaultProvider.getRequestingExecutor();
        LOGGER.config(LocalizationMessages.USING_DEFAULT_REQUEST_EXECUTOR(defaultExecutor));
        return defaultExecutor;
    }

    protected ExecutorService getInitialRespondingExecutor(ResponseExecutorsProvider defaultProvider) {
        for (ResponseExecutorsProvider provider : Providers.getAllProviders(this.locator, ResponseExecutorsProvider.class)) {
            ExecutorService respondingExecutor = provider.getRespondingExecutor();
            if (respondingExecutor == null) continue;
            LOGGER.config(LocalizationMessages.USING_CUSTOM_RESPONSE_EXECUTOR(respondingExecutor.getClass().getName(), provider.getClass().getName()));
            return respondingExecutor;
        }
        ExecutorService defaultExecutor = defaultProvider.getRespondingExecutor();
        LOGGER.config(LocalizationMessages.USING_DEFAULT_RESPONSE_EXECUTOR(defaultExecutor));
        return defaultExecutor;
    }

    public abstract ExecutorService getRequestingExecutor(REQUEST var1);

    public abstract ExecutorService getRespondingExecutor(REQUEST var1);
}

