/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.server.ChunkedResponse;
import org.jvnet.hk2.annotations.Inject;

@Provider
public class ChunkedResponseWriter
implements MessageBodyWriter<ChunkedResponse<?>> {
    private final Services services;

    public ChunkedResponseWriter(@Inject Services services) {
        this.services = services;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(ChunkedResponse.class);
    }

    public long getSize(ChunkedResponse<?> chunkedResponse, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(ChunkedResponse<?> chunkedResponse, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        References references = (References)((Injector)this.services.forContract(Injector.class).get()).inject(References.class);
        Class<?> chunkType = chunkedResponse.getChunkType();
        MessageBodyWorkers messageBodyWorkers = (MessageBodyWorkers)references.messageBodyWorkers.get();
        MessageBodyWriter messageBodyWriter = messageBodyWorkers.getMessageBodyWriter(chunkType, null, annotations, mediaType);
        do {
            Object chunk;
            try {
                chunk = chunkedResponse.getChunk();
            }
            catch (InterruptedException e) {
                chunk = null;
            }
            if (chunk == null) continue;
            try {
                messageBodyWriter.writeTo(chunk, chunkType, null, annotations, mediaType, httpHeaders, entityStream);
            }
            catch (IOException e) {
                chunkedResponse.close();
                throw e;
            }
        } while (!chunkedResponse.isClosed());
    }

    private static final class References {
        @Inject
        private Ref<MessageBodyWorkers> messageBodyWorkers;

        private References() {
        }
    }
}

