/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.RequestHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.ResponseHeaders;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Module;
import org.glassfish.hk2.TypeLiteral;
import org.glassfish.hk2.scopes.PerLookup;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.JaxrsProviders;
import org.glassfish.jersey.internal.ServiceFinderModule;
import org.glassfish.jersey.internal.ServiceProvidersModule;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.message.internal.MessagingModules;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.process.internal.DefaultRespondingContext;
import org.glassfish.jersey.process.internal.DefaultStagingContext;
import org.glassfish.jersey.process.internal.ExceptionMapper;
import org.glassfish.jersey.process.internal.FilterModule;
import org.glassfish.jersey.process.internal.HierarchicalRequestProcessor;
import org.glassfish.jersey.process.internal.ProcessingModule;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestProcessor;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.SecurityContextModule;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.StagingContext;
import org.glassfish.jersey.server.internal.inject.CloseableServiceModule;
import org.glassfish.jersey.server.internal.inject.ParameterInjectionModule;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.model.ResourceModelModule;
import org.glassfish.jersey.server.spi.ContainerProvider;
import org.jvnet.hk2.annotations.Inject;

public class ServerModule
extends AbstractModule {
    protected void configure() {
        this.install(new Module[]{new RequestScope.Module(), new ProcessingModule(), new ContextInjectionResolver.Module(), new MessagingModules.MessageBodyProviders(), new ServiceProvidersModule(), new MessageBodyFactory.Module(Singleton.class), new ExceptionMapperFactory.Module(Singleton.class), new ContextResolverFactory.Module(Singleton.class), new JaxrsProviders.Module(), new FilterModule(), new SecurityContextModule(), new ParameterInjectionModule(), new ResourceModelModule(), new RouterModule(), new ServiceFinderModule(ContainerProvider.class), new CloseableServiceModule()});
        this.bind((TypeLiteral)new TypeLiteral<ExceptionMapper<Throwable>>(){}).toInstance((Object)new ServerExceptionMapper());
        this.bind((TypeLiteral)new TypeLiteral<StagingContext<Request>>(){}).to(RequestStagingContext.class).in(RequestScope.class);
        this.bind((TypeLiteral)new TypeLiteral<StagingContext<Response>>(){}).to(ResponseStagingContext.class).in(RequestScope.class);
        this.bind(Request.class, new Class[0]).toFactory(RequestReferencingFactory.class).in(PerLookup.class);
        this.bind((TypeLiteral)new TypeLiteral<Ref<Request>>(){}).toFactory(ReferencingFactory.referenceFactory()).in(RequestScope.class);
        this.bind(RequestHeaders.class, new Class[0]).toFactory(RequestHeadersReferencingFactory.class).in(PerLookup.class);
        this.bind((TypeLiteral)new TypeLiteral<Ref<RequestHeaders>>(){}).toFactory(ReferencingFactory.referenceFactory()).in(RequestScope.class);
        this.bind(HttpHeaders.class, new Class[0]).toFactory(HttpHeadersReferencingFactory.class).in(PerLookup.class);
        this.bind((TypeLiteral)new TypeLiteral<Ref<HttpHeaders>>(){}).toFactory(ReferencingFactory.referenceFactory()).in(RequestScope.class);
        this.bind(Response.class, new Class[0]).toFactory(ResponseReferencingFactory.class).in(PerLookup.class);
        this.bind((TypeLiteral)new TypeLiteral<Ref<Response>>(){}).toFactory(ReferencingFactory.referenceFactory()).in(RequestScope.class);
        this.bind(ResponseHeaders.class, new Class[0]).toFactory(ResponseHeadersReferencingFactory.class).in(PerLookup.class);
        this.bind((TypeLiteral)new TypeLiteral<Ref<ResponseHeaders>>(){}).toFactory(ReferencingFactory.referenceFactory()).in(RequestScope.class);
        this.bind(RequestProcessor.class, new Class[0]).to(HierarchicalRequestProcessor.class);
        this.bind(ResponseProcessor.RespondingContext.class, new Class[0]).to(DefaultRespondingContext.class).in(RequestScope.class);
        this.bind().to(ResponseProcessor.Builder.class);
        this.bind().to(RequestInvoker.class);
    }

    private static class ResponseHeadersReferencingFactory
    extends ReferencingFactory<ResponseHeaders> {
        public ResponseHeadersReferencingFactory(@Inject Factory<Ref<ResponseHeaders>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class HttpHeadersReferencingFactory
    extends ReferencingFactory<HttpHeaders> {
        public HttpHeadersReferencingFactory(@Inject Factory<Ref<HttpHeaders>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class RequestHeadersReferencingFactory
    extends ReferencingFactory<RequestHeaders> {
        public RequestHeadersReferencingFactory(@Inject Factory<Ref<RequestHeaders>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class ResponseReferencingFactory
    extends ReferencingFactory<Response> {
        public ResponseReferencingFactory(@Inject Factory<Ref<Response>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class RequestReferencingFactory
    extends ReferencingFactory<Request> {
        public RequestReferencingFactory(@Inject Factory<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class ResponseStagingContext
    extends DefaultStagingContext<Response> {
        @Inject
        private Ref<Response> responseReference;
        @Inject
        private Ref<ResponseHeaders> responseHeadersReference;

        private ResponseStagingContext() {
        }

        protected void before(Stage<Response, ?> stage, Response response) {
            this.responseReference.set((Object)response);
            this.responseHeadersReference.set((Object)response.getHeaders());
        }

        protected void after(Stage<Response, ?> stage, Response response) {
            this.responseReference.set((Object)response);
            this.responseHeadersReference.set((Object)response.getHeaders());
        }
    }

    private static class RequestStagingContext
    extends DefaultStagingContext<Request> {
        @Inject
        private Ref<Request> requestReference;
        @Inject
        private Ref<RequestHeaders> requestHeadersReference;
        @Inject
        private Ref<HttpHeaders> httpHeadersReference;

        private RequestStagingContext() {
        }

        protected void before(Stage<Request, ?> stage, Request request) {
            this.requestReference.set((Object)request);
            this.requestHeadersReference.set((Object)request.getHeaders());
            this.httpHeadersReference.set((Object)Requests.httpHeaders((Request)request));
        }

        protected void after(Stage<Request, ?> stage, Request request) {
            this.requestReference.set((Object)request);
            this.requestHeadersReference.set((Object)request.getHeaders());
            this.httpHeadersReference.set((Object)Requests.httpHeaders((Request)request));
        }
    }

    private static class ServerExceptionMapper
    implements ExceptionMapper<Throwable> {
        private ServerExceptionMapper() {
        }

        public Response apply(Throwable exception) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

