/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.server.internal.inject.AbstractHttpContextValueFactory;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.spi.CloseableService;

public class CloseableServiceModule
extends AbstractModule {
    protected void configure() {
        this.bind(CloseableService.class, new Class[0]).toFactory(CloseableServiceFactory.class).in(Singleton.class);
    }

    private static class CloseableServiceFactory
    extends AbstractHttpContextValueFactory<CloseableService> {
        private CloseableServiceFactory() {
        }

        @Override
        protected CloseableService get(HttpContext context) {
            return new HttpContextCloseableService(context);
        }
    }

    private static class HttpContextCloseableService
    implements CloseableService {
        private static final Logger LOGGER = Logger.getLogger(HttpContextCloseableService.class.getName());
        private final HttpContext context;

        public HttpContextCloseableService(HttpContext context) {
            this.context = context;
        }

        public void add(Closeable c) {
            Set<Closeable> closeableSet = this.getCloseables();
            if (closeableSet == null) {
                closeableSet = new HashSet<Closeable>();
                this.context.getProperties().put(CloseableServiceFactory.class.getName(), closeableSet);
            }
            closeableSet.add(c);
        }

        public void close() {
            Set<Closeable> closeableSet = this.getCloseables();
            if (closeableSet != null) {
                for (Closeable c : closeableSet) {
                    try {
                        c.close();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.SEVERE, "Unable to close", ex);
                    }
                }
            }
        }

        private Set<Closeable> getCloseables() {
            Map<String, Object> properties = this.context.getProperties();
            return properties == null ? null : (Set)properties.get(HttpContextCloseableService.class.getName());
        }
    }
}

