/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import javax.ws.rs.FormParam;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.ExtractorException;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractHttpContextValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.jvnet.hk2.annotations.Inject;

final class FormParamValueFactoryProvider
extends AbstractValueFactoryProvider<FormParam> {
    public FormParamValueFactoryProvider(@Inject MultivaluedParameterExtractorProvider mpep, @Inject Injector injector) {
        super(mpep, injector, Parameter.Source.FORM);
    }

    @Override
    public AbstractHttpContextValueFactory<?> createValueFactory(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new FormParamValueFactory(e, !parameter.isEncoded());
    }

    private static final class FormParamValueFactory
    extends AbstractHttpContextValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;

        FormParamValueFactory(MultivaluedParameterExtractor<?> extractor, boolean decode) {
            this.extractor = extractor;
        }

        @Override
        public Object get(HttpContext context) {
            Form form = this.getCachedForm(context);
            if (form == null) {
                form = this.getForm(context);
                this.cacheForm(context, form);
            }
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)form.asMap());
            }
            catch (ExtractorException e) {
                throw new ParamException.FormParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }

        private void cacheForm(HttpContext context, Form form) {
            throw new UnsupportedOperationException("Form parameter injection not supported yet.");
        }

        private Form getCachedForm(HttpContext context) {
            throw new UnsupportedOperationException("Form parameter injection not supported yet.");
        }

        private Request ensureValidRequest(Request request) throws IllegalStateException {
            if (request.getMethod().equals("GET")) {
                throw new IllegalStateException("The @FormParam is utilized when the request method is GET");
            }
            if (!MediaTypes.typeEqual((MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MediaType)request.getHeaders().getMediaType())) {
                throw new IllegalStateException("The @FormParam is utilized when the content type of the request entity is not application/x-www-form-urlencoded");
            }
            return request;
        }

        private Form getForm(HttpContext context) {
            throw new UnsupportedOperationException("Form parameter injection not supported yet.");
        }
    }

    static final class InjectionResolver
    extends ParamInjectionResolver<FormParam> {
        public InjectionResolver() {
            super(FormParam.class, FormParamValueFactoryProvider.class);
        }
    }
}

