/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Date;
import javax.ws.rs.WebApplicationException;
import org.glassfish.jersey.internal.ExtractorException;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.internal.HttpDateFormat;
import org.glassfish.jersey.spi.StringValueReader;
import org.glassfish.jersey.spi.StringValueReaderProvider;

class StringReaderProviders {
    StringReaderProviders() {
    }

    public static class DateProvider
    implements StringValueReaderProvider {
        public <T> StringValueReader<T> getStringReader(final Class<T> type, Type genericType, Annotation[] annotations) {
            return type != Date.class ? null : new StringValueReader<T>(){

                public T fromString(String value) {
                    try {
                        return type.cast(HttpDateFormat.readDate((String)value));
                    }
                    catch (ParseException ex) {
                        throw new ExtractorException((Throwable)ex);
                    }
                }
            };
        }
    }

    public static class TypeFromStringEnum
    extends TypeFromString {
        @Override
        public <T> StringValueReader<T> getStringReader(Class<T> type, Type genericType, Annotation[] annotations) {
            return !Enum.class.isAssignableFrom(type) ? null : super.getStringReader(type, genericType, annotations);
        }
    }

    public static class TypeFromString
    implements StringValueReaderProvider {
        public <T> StringValueReader<T> getStringReader(final Class<T> type, Type genericType, Annotation[] annotations) {
            final Method fromStringMethod = ReflectionHelper.getFromStringStringMethod(type);
            return fromStringMethod == null ? null : new AbstractStringReader<T>(){

                @Override
                public T _fromString(String value) throws Exception {
                    return type.cast(fromStringMethod.invoke(null, value));
                }
            };
        }
    }

    public static class TypeValueOf
    implements StringValueReaderProvider {
        public <T> StringValueReader<T> getStringReader(final Class<T> type, Type genericType, Annotation[] annotations) {
            final Method valueOf = ReflectionHelper.getValueOfStringMethod(type);
            return valueOf == null ? null : new AbstractStringReader<T>(){

                @Override
                public T _fromString(String value) throws Exception {
                    return type.cast(valueOf.invoke(null, value));
                }
            };
        }
    }

    public static class StringConstructor
    implements StringValueReaderProvider {
        public <T> StringValueReader<T> getStringReader(final Class<T> type, Type genericType, Annotation[] annotations) {
            final Constructor constructor = ReflectionHelper.getStringConstructor(type);
            return constructor == null ? null : new AbstractStringReader<T>(){

                @Override
                protected T _fromString(String value) throws Exception {
                    return type.cast(constructor.newInstance(value));
                }
            };
        }
    }

    private static abstract class AbstractStringReader<T>
    implements StringValueReader<T> {
        private AbstractStringReader() {
        }

        public T fromString(String value) {
            try {
                return this._fromString(value);
            }
            catch (InvocationTargetException ex) {
                Throwable target = ex.getTargetException();
                if (target instanceof WebApplicationException) {
                    throw (WebApplicationException)target;
                }
                throw new ExtractorException(target);
            }
            catch (Exception ex) {
                throw new ProcessingException((Throwable)ex);
            }
        }

        protected abstract T _fromString(String var1) throws Exception;
    }
}

