/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.Comparator;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.QualitySourceMediaType;

class CombinedClientServerMediaType {
    MediaType combinedMediaType;
    int q;
    int qs;
    int d;
    public static final CombinedClientServerMediaType NO_MATCH = new CombinedClientServerMediaType();
    private static final Comparator<MediaType> partialOrderComparator = new Comparator<MediaType>(){

        @Override
        public int compare(MediaType o1, MediaType o2) {
            return CombinedClientServerMediaType.m2i(o2) - CombinedClientServerMediaType.m2i(o1);
        }
    };
    public static final Comparator<CombinedClientServerMediaType> COMPARATOR = new Comparator<CombinedClientServerMediaType>(){

        @Override
        public int compare(CombinedClientServerMediaType c1, CombinedClientServerMediaType c2) {
            int partialComparism = partialOrderComparator.compare(c1.combinedMediaType, c2.combinedMediaType);
            if (partialComparism > 0) {
                return 1;
            }
            if (partialComparism == 0) {
                if (c1.q > c2.q) {
                    return 1;
                }
                if (c1.q == c2.q) {
                    if (c1.qs > c2.qs) {
                        return 1;
                    }
                    if (c1.qs == c2.qs) {
                        return c2.d - c1.d;
                    }
                }
            }
            return -1;
        }
    };

    private static int wildcardsMatched(MediaType clientMt, MediaType serverMt) {
        return CombinedClientServerMediaType.b2i(clientMt.isWildcardType() ^ serverMt.isWildcardType()) + CombinedClientServerMediaType.b2i(clientMt.isWildcardSubtype() ^ serverMt.isWildcardSubtype());
    }

    private static int b2i(boolean b) {
        return b ? 1 : 0;
    }

    private static int m2i(MediaType mt) {
        return 10 * CombinedClientServerMediaType.b2i(mt.isWildcardType()) + CombinedClientServerMediaType.b2i(mt.isWildcardSubtype());
    }

    private CombinedClientServerMediaType() {
    }

    public static CombinedClientServerMediaType create(MediaType clientMt, MediaType serverMt) {
        if (!clientMt.isCompatible(serverMt)) {
            return NO_MATCH;
        }
        CombinedClientServerMediaType result = new CombinedClientServerMediaType();
        result.combinedMediaType = MediaTypes.stripQualityParams((MediaType)MediaTypes.mostSpecific((MediaType)clientMt, (MediaType)serverMt));
        result.d = CombinedClientServerMediaType.wildcardsMatched(clientMt, serverMt);
        result.q = MediaTypes.getQuality((MediaType)clientMt);
        result.qs = QualitySourceMediaType.getQualitySource((MediaType)serverMt);
        return result;
    }

    public String toString() {
        return String.format("%s:%d:%d:%d", this.combinedMediaType, this.q, this.qs, this.d);
    }
}

