/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.regex.MatchResult;
import javax.ws.rs.core.Request;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.uri.PathPattern;

public class PathPatternRouteAcceptor
implements TreeAcceptor {
    private final Factory<RouterModule.RoutingContext> contextProvider;
    private final List<Pair<PathPattern, List<Factory<TreeAcceptor>>>> acceptedRoutes;

    private PathPatternRouteAcceptor(Factory<RouterModule.RoutingContext> provider, List<Pair<PathPattern, List<Factory<TreeAcceptor>>>> routes) {
        this.contextProvider = provider;
        this.acceptedRoutes = routes;
    }

    public Pair<Request, Iterator<TreeAcceptor>> apply(Request request) {
        RouterModule.RoutingContext rc = (RouterModule.RoutingContext)this.contextProvider.get();
        String path = rc.getFinalMatchingGroup();
        for (Pair<PathPattern, List<Factory<TreeAcceptor>>> acceptedRoute : this.acceptedRoutes) {
            MatchResult m = ((PathPattern)acceptedRoute.left()).match((CharSequence)path);
            if (m == null) continue;
            rc.pushMatchResult(m);
            rc.pushTemplate(((PathPattern)acceptedRoute.left()).getTemplate());
            List acceptorProviders = (List)acceptedRoute.right();
            Object acceptors = acceptorProviders.isEmpty() ? Iterators.emptyIterator() : (acceptorProviders.size() == 1 ? Iterators.transform((Iterator)Iterators.singletonIterator(acceptorProviders.iterator().next()), RouterModule.FACTORY_TO_ACCEPTOR_TRANSFORMATION) : Iterators.transform(acceptorProviders.iterator(), RouterModule.FACTORY_TO_ACCEPTOR_TRANSFORMATION));
            return Tuples.of((Object)request, (Object)acceptors);
        }
        return Stages.terminalTreeContinuation((Request)request);
    }

    public class Builder {
        private final Factory<RouterModule.RoutingContext> contextProvider;

        public Builder(Factory<RouterModule.RoutingContext> contextProvider) {
            this.contextProvider = contextProvider;
        }

        public PathPatternRouteAcceptor build(List<Pair<PathPattern, List<Factory<TreeAcceptor>>>> routes) {
            return new PathPatternRouteAcceptor(this.contextProvider, routes);
        }
    }
}

