/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.HandlerConstructor;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.MethodHandler;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.model.ResourceModelValidator;
import org.glassfish.jersey.server.model.Routed;
import org.glassfish.jersey.uri.UriTemplate;

public class BasicValidator
extends ResourceModelValidator {
    private final MessageBodyWorkers workers;
    private static final Set<Class> PARAM_ANNOTATION_SET = BasicValidator.createParamAnnotationSet();
    private static final List<MediaType> StarTypeList = Arrays.asList(new MediaType("*", "*"));

    public BasicValidator() {
        this(new LinkedList<ResourceModelIssue>(), null);
    }

    public BasicValidator(List<ResourceModelIssue> issueList) {
        this(issueList, null);
    }

    public BasicValidator(List<ResourceModelIssue> issueList, MessageBodyWorkers workers) {
        super(issueList);
        this.workers = workers;
    }

    @Override
    public void visitResourceClass(Resource resource) {
        if (resource.isRootResource() && null == resource.getPath()) {
            this.addFatalIssue(resource, LocalizationMessages.RES_URI_PATH_INVALID(resource.getName(), resource.getPath()));
        }
        this.checkConsumesProducesAmbiguities(resource);
        this.checkSRLAmbiguities(resource);
    }

    @Override
    public void visitResourceHandlerConstructor(HandlerConstructor constructor) {
    }

    @Override
    public void visitInvocable(Invocable invocable) {
    }

    @Override
    public void visitMethodHandler(MethodHandler methodHandler) {
    }

    @Override
    public void visitResourceMethod(ResourceMethod method) {
        switch (method.getType()) {
            case RESOURCE_METHOD: {
                this.visitJaxrsResourceMethod(method);
                break;
            }
            case SUB_RESOURCE_METHOD: {
                this.visitSubResourceMethod(method);
                break;
            }
            case SUB_RESOURCE_LOCATOR: {
                this.visitSubResourceLocator(method);
            }
        }
    }

    private void visitJaxrsResourceMethod(ResourceMethod method) {
        this.checkMethod(method);
    }

    private void checkMethod(ResourceMethod method) {
        Type responseType;
        Invocable invocable = method.getInvocable();
        this.checkParameters(method);
        if ("GET".equals(method.getHttpMethod())) {
            if (Void.TYPE == invocable.getHandlingMethod().getReturnType() && !method.isSuspendDeclared()) {
                this.addMinorIssue(method, LocalizationMessages.GET_RETURNS_VOID(invocable.getHandlingMethod()));
            }
            if (invocable.requiresEntity() && !invocable.isInflector()) {
                this.addMinorIssue(method, LocalizationMessages.GET_CONSUMES_ENTITY(invocable.getHandlingMethod()));
            }
            for (Parameter p : invocable.getParameters()) {
                if (!p.isAnnotationPresent(FormParam.class)) continue;
                this.addFatalIssue(method, LocalizationMessages.GET_CONSUMES_FORM_PARAM(invocable.getHandlingMethod()));
                break;
            }
        }
        LinkedList<String> httpMethodAnnotations = new LinkedList<String>();
        for (Annotation a : invocable.getHandlingMethod().getDeclaredAnnotations()) {
            if (null != a.annotationType().getAnnotation(HttpMethod.class)) {
                httpMethodAnnotations.add(((Object)a).toString());
                continue;
            }
            if (a.annotationType() != Path.class || method.getType() != ResourceMethod.JaxrsType.RESOURCE_METHOD) continue;
            this.addMinorIssue(method, LocalizationMessages.SUB_RES_METHOD_TREATED_AS_RES_METHOD(invocable.getHandlingMethod(), ((Path)a).value()));
        }
        if (httpMethodAnnotations.size() > 1) {
            this.addFatalIssue(method, LocalizationMessages.MULTIPLE_HTTP_METHOD_DESIGNATORS(invocable.getHandlingMethod(), ((Object)httpMethodAnnotations).toString()));
        }
        if (!BasicValidator.isConcreteType(responseType = invocable.getResponseType().getType())) {
            this.addMinorIssue(invocable.getHandlingMethod(), LocalizationMessages.TYPE_OF_METHOD_NOT_RESOLVABLE_TO_CONCRETE_TYPE(responseType, invocable.getHandlingMethod().toGenericString()));
        }
    }

    private void visitSubResourceMethod(ResourceMethod method) {
        this.checkMethod(method);
        if (null == method.getPath() || null == method.getPath() || method.getPath().length() == 0) {
            this.addFatalIssue(method, LocalizationMessages.SUBRES_METHOD_URI_PATH_INVALID(method.getInvocable().getHandlingMethod(), method.getPath()));
        }
    }

    private void visitSubResourceLocator(ResourceMethod locator) {
        this.checkParameters(locator);
        Invocable invocable = locator.getInvocable();
        if (Void.TYPE == invocable.getResponseType().getRawType()) {
            this.addFatalIssue(locator, LocalizationMessages.SUBRES_LOC_RETURNS_VOID(invocable.getHandlingMethod()));
        }
        if (null == locator.getPath() || null == locator.getPath() || locator.getPath().length() == 0) {
            this.addFatalIssue(locator, LocalizationMessages.SUBRES_LOC_URI_PATH_INVALID(invocable.getHandlingMethod(), locator.getPath()));
        }
    }

    private static Set<Class> createParamAnnotationSet() {
        HashSet<Class> set = new HashSet<Class>(6);
        set.add(Context.class);
        set.add(HeaderParam.class);
        set.add(CookieParam.class);
        set.add(MatrixParam.class);
        set.add(QueryParam.class);
        set.add(PathParam.class);
        return Collections.unmodifiableSet(set);
    }

    static void validateParameter(List<ResourceModelIssue> issueList, Parameter parameter, Object source, String reportedSourceName, String reportedParameterName) {
        Type paramType;
        Annotation[] annotations;
        int counter = 0;
        for (Annotation a : annotations = parameter.getAnnotations()) {
            if (!PARAM_ANNOTATION_SET.contains(a.annotationType()) || ++counter <= 1) continue;
            issueList.add(new ResourceModelIssue(source, LocalizationMessages.AMBIGUOUS_PARAMETER(reportedSourceName, reportedParameterName), false));
            break;
        }
        if (!BasicValidator.isConcreteType(paramType = parameter.getParameterType().getType())) {
            issueList.add(new ResourceModelIssue(source, LocalizationMessages.PARAMETER_UNRESOLVABLE(reportedParameterName, paramType, reportedSourceName), false));
        }
    }

    private static boolean isConcreteType(Type t) {
        if (t instanceof ParameterizedType) {
            return BasicValidator.isConcreteParameterizedType((ParameterizedType)t);
        }
        return t instanceof Class;
    }

    private static boolean isConcreteParameterizedType(ParameterizedType pt) {
        boolean isConcrete = true;
        for (Type t : pt.getActualTypeArguments()) {
            isConcrete &= BasicValidator.isConcreteType(t);
        }
        return isConcrete;
    }

    private void checkParameters(ResourceMethod method) {
        Invocable invocable = method.getInvocable();
        Method handlingMethod = invocable.getHandlingMethod();
        int paramCount = 0;
        for (Parameter p : invocable.getParameters()) {
            BasicValidator.validateParameter(this.getIssueList(), p, handlingMethod, handlingMethod.toGenericString(), Integer.toString(++paramCount));
            if (method.getType() != ResourceMethod.JaxrsType.SUB_RESOURCE_LOCATOR || Parameter.Source.ENTITY != p.getSource()) continue;
            this.addFatalIssue(method, LocalizationMessages.SUBRES_LOC_HAS_ENTITY_PARAM(invocable.getHandlingMethod()));
        }
    }

    private void checkConsumesProducesAmbiguities(Resource resource) {
        List<ResourceMethod> subResourceMethods;
        List<ResourceMethod> resourceMethods = resource.getResourceMethods();
        if (resourceMethods.size() >= 2) {
            for (ResourceMethod m1 : resourceMethods.subList(0, resourceMethods.size() - 1)) {
                for (ResourceMethod m2 : resourceMethods.subList(resourceMethods.indexOf(m1) + 1, resourceMethods.size())) {
                    if (!this.sameHttpMethod(m1, m2)) continue;
                    this.checkIntersectingMediaTypes(resource, m1.getHttpMethod(), m1, m2);
                }
            }
        }
        if ((subResourceMethods = resource.getSubResourceMethods()).size() >= 2) {
            for (ResourceMethod m1 : subResourceMethods.subList(0, subResourceMethods.size() - 1)) {
                for (ResourceMethod m2 : subResourceMethods.subList(subResourceMethods.indexOf(m1) + 1, subResourceMethods.size())) {
                    if (!this.samePath(m1, m2) || !this.sameHttpMethod(m1, m2)) continue;
                    this.checkIntersectingMediaTypes(resource, m1.getHttpMethod(), m1, m2);
                }
            }
        }
    }

    private void checkSRLAmbiguities(Resource resource) {
        List<ResourceMethod> subResourceLocators = resource.getSubResourceLocators();
        if (subResourceLocators.size() >= 2) {
            for (ResourceMethod m1 : subResourceLocators.subList(0, subResourceLocators.size() - 1)) {
                for (ResourceMethod m2 : subResourceLocators.subList(subResourceLocators.indexOf(m1) + 1, subResourceLocators.size())) {
                    if (!this.samePath(m1, m2)) continue;
                    this.addFatalIssue(resource, LocalizationMessages.AMBIGUOUS_SRLS(resource.getName(), m1.getPath(), m2.getPath()));
                }
            }
        }
    }

    private void checkIntersectingMediaTypes(Resource resource, String httpMethod, ResourceMethod m1, ResourceMethod m2) {
        List<MediaType> outputTypes2;
        List<MediaType> outputTypes1;
        List<MediaType> inputTypes2;
        List<MediaType> inputTypes1 = this.getEffectiveInputTypes(m1);
        if (this.intersectingMediaTypes(inputTypes1, inputTypes2 = this.getEffectiveInputTypes(m2), outputTypes1 = this.getEffectiveOutputTypes(m1), outputTypes2 = this.getEffectiveOutputTypes(m2))) {
            String rcName = resource.getName();
            if (m1.getInvocable().requiresEntity()) {
                this.addFatalIssue(resource, LocalizationMessages.AMBIGUOUS_RMS_IN(rcName, httpMethod, m1.getInvocable().getHandlingMethod(), m2.getInvocable().getHandlingMethod()));
            } else {
                this.addFatalIssue(resource, LocalizationMessages.AMBIGUOUS_RMS_OUT(rcName, httpMethod, m1.getInvocable().getHandlingMethod(), m2.getInvocable().getHandlingMethod()));
            }
        }
    }

    private List<MediaType> getEffectiveInputTypes(ResourceMethod resourceMethod) {
        if (!resourceMethod.getConsumedTypes().isEmpty()) {
            return resourceMethod.getConsumedTypes();
        }
        LinkedList<MediaType> result = new LinkedList<MediaType>();
        if (this.workers != null) {
            for (Parameter p : resourceMethod.getInvocable().getParameters()) {
                if (p.getSource() != Parameter.Source.ENTITY) continue;
                GenericType<?> paramType = p.getParameterType();
                result.addAll(this.workers.getMessageBodyReaderMediaTypes(paramType.getRawType(), paramType.getType(), p.getDeclaredAnnotations()));
            }
        }
        return result.isEmpty() ? StarTypeList : result;
    }

    private List<MediaType> getEffectiveOutputTypes(ResourceMethod resourceMethod) {
        if (!resourceMethod.getProducedTypes().isEmpty()) {
            return resourceMethod.getProducedTypes();
        }
        LinkedList<MediaType> result = new LinkedList<MediaType>();
        if (this.workers != null) {
            Invocable invocable = resourceMethod.getInvocable();
            result.addAll(this.workers.getMessageBodyWriterMediaTypes(invocable.getResponseType().getRawType(), invocable.getResponseType().getType(), invocable.getHandlingMethod().getDeclaredAnnotations()));
        }
        return result.isEmpty() ? StarTypeList : result;
    }

    private boolean sameHttpMethod(ResourceMethod m1, ResourceMethod m2) {
        return m1.getHttpMethod().equals(m2.getHttpMethod());
    }

    private boolean intersectingMediaTypes(List<MediaType> i1, List<MediaType> i2, List<MediaType> o1, List<MediaType> o2) {
        return MediaTypes.intersect(i1, i2) && MediaTypes.intersect(o1, o2);
    }

    private boolean samePath(Routed m1, Routed m2) {
        return new UriTemplate(m1.getPath()).equals((Object)new UriTemplate(m2.getPath()));
    }
}

