/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.model.Consuming;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.MethodHandler;
import org.glassfish.jersey.server.model.Producing;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelVisitor;
import org.glassfish.jersey.server.model.Routed;
import org.glassfish.jersey.server.model.Suspendable;
import org.glassfish.jersey.uri.PathPattern;

public class ResourceMethod
implements ResourceModelComponent,
Routed,
Producing,
Consuming,
Suspendable {
    private final JaxrsType type;
    private final String httpMethod;
    private final String path;
    private final PathPattern pathPattern;
    private final List<MediaType> consumedTypes;
    private final List<MediaType> producedTypes;
    private final boolean suspended;
    private final long suspendTimeout;
    private final TimeUnit suspendTimeoutUnit;
    private final Invocable invocable;

    private ResourceMethod(String httpMethod, String path, Collection<MediaType> consumedTypes, Collection<MediaType> producedTypes, boolean suspended, long suspendTimeout, TimeUnit suspendTimeoutUnit, Invocable invocable) {
        this.type = JaxrsType.classify(httpMethod, path);
        this.httpMethod = httpMethod == null ? httpMethod : httpMethod.toUpperCase();
        this.path = path;
        this.pathPattern = this.type.createPatternFor(path);
        this.consumedTypes = Collections.unmodifiableList(Lists.newArrayList(consumedTypes));
        this.producedTypes = Collections.unmodifiableList(Lists.newArrayList(producedTypes));
        this.invocable = invocable;
        this.suspended = suspended;
        this.suspendTimeout = suspendTimeout;
        this.suspendTimeoutUnit = suspendTimeoutUnit;
    }

    public JaxrsType getType() {
        return this.type;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public Invocable getInvocable() {
        return this.invocable;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public PathPattern getPathPattern() {
        return this.pathPattern;
    }

    @Override
    public List<MediaType> getConsumedTypes() {
        return this.consumedTypes;
    }

    @Override
    public List<MediaType> getProducedTypes() {
        return this.producedTypes;
    }

    @Override
    public long getSuspendTimeout() {
        return this.suspendTimeout;
    }

    @Override
    public TimeUnit getSuspendTimeoutUnit() {
        return this.suspendTimeoutUnit;
    }

    @Override
    public boolean isSuspendDeclared() {
        return this.suspended;
    }

    @Override
    public List<? extends ResourceModelComponent> getComponents() {
        return Arrays.asList(this.invocable);
    }

    @Override
    public void accept(ResourceModelVisitor visitor) {
        visitor.visitResourceMethod(this);
    }

    public String toString() {
        return "ResourceMethod{httpMethod=" + this.httpMethod + ", path=" + this.path + ", consumedTypes=" + this.consumedTypes + ", producedTypes=" + this.producedTypes + ", suspended=" + this.suspended + ", suspendTimeout=" + this.suspendTimeout + ", suspendTimeoutUnit=" + (Object)((Object)this.suspendTimeoutUnit) + ", invocable=" + this.invocable + '}';
    }

    public static final class Builder {
        private final Resource.Builder parent;
        private String httpMethod;
        private String path;
        private final Set<MediaType> consumedTypes;
        private final Set<MediaType> producedTypes;
        private boolean suspended;
        private long suspendTimeout;
        private TimeUnit suspendTimeoutUnit;
        private Class<?> handlerClass;
        private Object handlerInstance;
        private Method handlingMethod;
        private boolean encodedParams;

        Builder(Resource.Builder parent) {
            this.parent = parent;
            this.httpMethod = null;
            this.path = "";
            this.consumedTypes = Sets.newLinkedHashSet();
            this.producedTypes = Sets.newLinkedHashSet();
            this.suspended = false;
            this.suspendTimeout = 0L;
            this.suspendTimeoutUnit = TimeUnit.MILLISECONDS;
            this.encodedParams = false;
        }

        public Builder httpMethod(String name) {
            this.httpMethod = name;
            return this;
        }

        public Builder path(String path) {
            if (path == null) {
                path = "";
            }
            this.path = path;
            return this;
        }

        public Builder produces(String ... types) {
            return this.produces(MediaTypes.createFrom((String[])types));
        }

        public Builder produces(MediaType ... types) {
            return this.produces(Arrays.asList(types));
        }

        public Builder produces(Collection<MediaType> types) {
            this.producedTypes.addAll(types);
            return this;
        }

        public Builder consumes(String ... types) {
            return this.produces(MediaTypes.createFrom((String[])types));
        }

        public Builder consumes(MediaType ... types) {
            return this.produces(Arrays.asList(types));
        }

        public Builder consumes(Collection<MediaType> types) {
            this.consumedTypes.addAll(types);
            return this;
        }

        public Builder suspended(long timeout, TimeUnit unit) {
            this.suspended = true;
            this.suspendTimeout = timeout;
            this.suspendTimeoutUnit = unit;
            return this;
        }

        public Builder encodedParameters(boolean value) {
            this.encodedParams = value;
            return this;
        }

        public Builder handledBy(Class<?> handlerClass, Method method) {
            this.handlerInstance = null;
            this.handlerClass = handlerClass;
            this.handlingMethod = method;
            return this;
        }

        public Builder handledBy(Object handlerInstance, Method method) {
            this.handlerClass = null;
            this.handlerInstance = handlerInstance;
            this.handlingMethod = method;
            return this;
        }

        public Builder handledBy(Inflector<Request, ?> inflector) {
            return this.handledBy(inflector, Invocable.APPLY_INFLECTOR_METHOD);
        }

        public Builder handledBy(Class<? extends Inflector> inflectorClass) {
            return this.handledBy(inflectorClass, Invocable.APPLY_INFLECTOR_METHOD);
        }

        public ResourceMethod build() {
            Invocable invocable = this.createInvocable();
            ResourceMethod method = new ResourceMethod(this.httpMethod, this.path, this.consumedTypes, this.producedTypes, this.suspended, this.suspendTimeout, this.suspendTimeoutUnit, invocable);
            this.parent.onBuildMethod(this, method);
            return method;
        }

        private Invocable createInvocable() {
            assert (this.handlerClass != null || this.handlerInstance != null);
            MethodHandler handler = this.handlerClass != null ? MethodHandler.create(this.handlerClass, this.encodedParams) : MethodHandler.create(this.handlerInstance);
            return Invocable.create(handler, this.handlingMethod, this.encodedParams);
        }
    }

    public static enum JaxrsType {
        RESOURCE_METHOD{

            @Override
            PathPattern createPatternFor(String pathTemplate) {
                return PathPattern.END_OF_PATH_PATTERN;
            }
        }
        ,
        SUB_RESOURCE_METHOD{

            @Override
            PathPattern createPatternFor(String pathTemplate) {
                return new PathPattern(pathTemplate, PathPattern.RightHandPath.capturingZeroSegments);
            }
        }
        ,
        SUB_RESOURCE_LOCATOR{

            @Override
            PathPattern createPatternFor(String pathTemplate) {
                return new PathPattern(pathTemplate, PathPattern.RightHandPath.capturingZeroOrMoreSegments);
            }
        };


        abstract PathPattern createPatternFor(String var1);

        private static JaxrsType classify(String httpMethod, String methodPath) {
            if (httpMethod != null) {
                if (!httpMethod.isEmpty()) {
                    if (methodPath.isEmpty() || "/".equals(methodPath)) {
                        return RESOURCE_METHOD;
                    }
                    return SUB_RESOURCE_METHOD;
                }
            } else if (!methodPath.isEmpty()) {
                return SUB_RESOURCE_LOCATOR;
            }
            throw new IllegalStateException(String.format("Unknown resource method model type: HTTP method = '%s', method path = '%s'.", httpMethod, methodPath));
        }
    }
}

