/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodDispatcherFactory;
import org.glassfish.jersey.server.model.ResourceMethodInvocationHandlerFactory;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;
import org.jvnet.hk2.annotations.Inject;

public class ResourceMethodInvoker
implements Inflector<Request, Response> {
    private final Factory<RouterModule.RoutingContext> routingContextFactory;
    private final Factory<InvocationContext> invocationContextFactory;
    private final ResourceMethod method;
    private final ResourceMethodDispatcher dispatcher;

    private ResourceMethodInvoker(Factory<RouterModule.RoutingContext> routingContextFactory, Factory<InvocationContext> invocationContextFactory, ResourceMethodDispatcher.Provider dispatcherProvider, ResourceMethodInvocationHandlerProvider invocationHandlerProvider, ResourceMethod method) {
        this.routingContextFactory = routingContextFactory;
        this.invocationContextFactory = invocationContextFactory;
        this.method = method;
        Invocable invocable = method.getInvocable();
        this.dispatcher = dispatcherProvider.create(invocable, invocationHandlerProvider.create(invocable));
    }

    public Response apply(Request request) {
        Object resource = ((RouterModule.RoutingContext)this.routingContextFactory.get()).peekMatchedResource();
        InvocationContext invocationCtx = (InvocationContext)this.invocationContextFactory.get();
        if (this.method.isSuspendDeclared()) {
            invocationCtx.setSuspendTimeout(this.method.getSuspendTimeout(), this.method.getSuspendTimeoutUnit());
        }
        Response response = this.dispatcher.dispatch(resource, request);
        Invocable invocable = this.method.getInvocable();
        RouterModule.RoutingContext routingCtx = (RouterModule.RoutingContext)this.routingContextFactory.get();
        routingCtx.setResponseMethodType(invocable.getResponseType().getType());
        routingCtx.setResponseMethodAnnotations(invocable.getHandlingMethod().getDeclaredAnnotations());
        if (this.method.isSuspendDeclared()) {
            invocationCtx.setResponse(resource);
            invocationCtx.trySuspend();
        }
        return response;
    }

    public String toString() {
        return this.method.getInvocable().getHandlingMethod().toString();
    }

    public static class Builder {
        @Inject
        private Factory<RouterModule.RoutingContext> routingContextFactory;
        @Inject
        private Factory<InvocationContext> invocationContextFactory;
        @Inject
        private ResourceMethodDispatcherFactory dispatcherProviderFactory;
        @Inject
        private ResourceMethodInvocationHandlerFactory invocationHandlerProviderFactory;

        public ResourceMethodInvoker build(ResourceMethod method) {
            return new ResourceMethodInvoker(this.routingContextFactory, this.invocationContextFactory, this.dispatcherProviderFactory, this.invocationHandlerProviderFactory, method);
        }
    }
}

