/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.util.List;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.model.ResourceModelVisitor;

public abstract class ResourceModelValidator
implements ResourceModelVisitor {
    private final List<ResourceModelIssue> issueList;

    public ResourceModelValidator(List<ResourceModelIssue> issueList) {
        this.issueList = issueList;
    }

    public List<ResourceModelIssue> getIssueList() {
        return this.issueList;
    }

    protected final void addFatalIssue(Object source, String message) {
        this.issueList.add(new ResourceModelIssue(source, message, true));
    }

    protected final void addMinorIssue(Object source, String message) {
        this.issueList.add(new ResourceModelIssue(source, message, false));
    }

    public boolean fatalIssuesFound() {
        for (ResourceModelIssue issue : this.getIssueList()) {
            if (!issue.isFatal()) continue;
            return true;
        }
        return false;
    }

    public void cleanIssueList() {
        this.issueList.clear();
    }

    public void validate(ResourceModelComponent component) {
        component.accept(this);
        List<? extends ResourceModelComponent> componentList = component.getComponents();
        if (null != componentList) {
            for (ResourceModelComponent resourceModelComponent : componentList) {
                this.validate(resourceModelComponent);
            }
        }
    }
}

